/* Flegovi */
`define CF 2'd0
`define ZF 2'd1
`define SF 2'd2
`define OF 2'd3

/* Kolo predstavlja registar koji cuva osnovne flegove (O, S, Z, C)
   procesora. Oni se ucitavaju sa 4-bitnog ulaza in kad god je e_in
   aktivan i pamte se u registru. Vrednost sacuvanih flagova je uvek
   dostupan na izlazu out */
module psw(in, out, e_in);
   input[3:0] in;
   input      e_in;
   output reg [3:0] out;

   initial
     out <= 0;
   
   
   always @(in or e_in)
     if(e_in)
       out <= in;

   always @(out)
     $display($time, ": psw (oszc) = %b", out);	  
   
endmodule // psw
