/* MDR registar sluzi za komunikaciju sa memorijom. Prilikom citanja iz memorije
   procitana vrednost dospeva u ovaj registar. Prilikom pisanja, vrednost se najpre
   stavi u ovaj registar, a onda se inicira transfer. Moguce je upisati vrednost
   u ovaj registar preko bilo koje od magistrala, kao i poslati vrednost na bilo
   koju od magistrala. Takodje, prilikom memorijskog transfera moze se traziti 
   da se vrednost postavi na magistralu podataka (data izlaz), kao i da se ucita
   sa magistrale podataka (data ulaz). Ulaz e_calc_const vrsi pomeranje ovog 
   registra aritmeticki u desno za 8 pozicija (koristi se prilikom ucitavanja
   konstante LDC instrukcijom).
  */
module mdr(bus_a, bus_b, data, e_a_in, e_b_in, e_data_in, e_a_out, e_b_out, e_data_out, e_calc_const);
   inout [31:0] bus_a, bus_b;
   input 	e_a_in, e_b_in;   
   input 	e_a_out, e_b_out;   
   inout [31:0]  data;
   input 	 e_data_in, e_data_out;
   input 	 e_calc_const;
      
   reg [31:0] 	 r;
      
   assign data = e_data_out ? r : 32'hzzzzzzzz;
   assign bus_a = e_a_out ? r : 32'hzzzzzzzz;
   assign bus_b = e_b_out ? r : 32'hzzzzzzzz;

   initial
     r <= 0;
   
   always @(e_a_in or bus_a)
     if(e_a_in)
       r <= bus_a;

   always @(e_b_in or bus_b)
     if(e_b_in)
       r <= bus_b;

   always @(e_data_in or data)
     if(e_data_in)
       r <= data;

   always @(posedge e_calc_const)
     r <= { {8{r[31]}}, r } >> 8;

   always @(r)
     $display($time, ": mdr = %h", r);	  

   
endmodule // mdr

