/* U MAR registru se izracunava adresa koju treba poslati memoriji 
   prilikom transfera. Moguce je ucitati vrednost sa bilo koje od
   magistrala, a takodje je moguce izracunati adresu po formuli
   bus_a + bus_b[31:8] * 4, sto je korisno kod relativnog adresiranja
   (PC se postavi na bus_a, a MDR na bus_b). Kada se inicira transfer,
   vrednost ovog registra se direktno postavlja na adresnu magistralu
   (addr izlaz) */
module mar(bus_a, bus_b, addr, e_a_in, e_b_in, e_addr_out, e_calc_addr);
   input [31:0] bus_a, bus_b;
   input 	e_a_in, e_b_in;   
   output [31:0] addr;
   input 	 e_addr_out;
   input 	 e_calc_addr;
   
   reg [31:0] 	 r;
      
   assign addr = e_addr_out ? r : 32'hzzzzzzzz;

   initial
     r <= 0;
   
   always @(e_a_in or bus_a)
     if(e_a_in)
       r <= bus_a;

   always @(e_b_in or bus_b)
     if(e_b_in)
       r <= bus_b;

   always @(e_calc_addr or bus_a or bus_b)
     if(e_calc_addr)
       r <= bus_a + (({ {6{bus_b[31]}}, {26{1'b0}} } | (bus_b >> 6)) & 32'hfffffffc);
   

   always @(r)
     $display($time, ": mar = %h", r);	  


   
   
endmodule // mar

