/* Pomocni registar u kome se privremeno cuva vrednost koju je
 izracunala ALU jedinica. Moze ucitati i zapamtiti vrednost sa
 izlaza ALU jedinice koju kasnije moze poslati na A ili B 
 magistralu.  */
module ac(bus_a, bus_b, alu_in, e_alu_in, e_a_out, e_b_out);
   output[31:0] bus_a, bus_b;
   input       e_a_out, e_b_out;
   input [31:0] alu_in;
   input 	e_alu_in;
   
   reg [31:0]  r;

   assign bus_a = e_a_out ? r : 32'hzzzzzzzz;
   assign bus_b = e_b_out ? r : 32'hzzzzzzzz;

   initial
     r <= 0;
   
   always @(e_alu_in or alu_in)
     if(e_alu_in)
       r <= alu_in;

   always @(r)
     $display($time, ": ac = %d", r);	  
   
endmodule // ac
