`define START 0
`define ZERO 1
`define ONE 2
`define SUCCESS 3
`define ERROR 4

/* Konacni automat koji prepoznaje regularni jezik (00|11)+. Niska bitova se
 ucitava sa ulaza in (u svakom signalu sata se uzima po jedan bit). Vrednost
 na izlazu je 1 akko se nalazimo u zavrsnom stanju (SUCCESS), tj. ako je 
 do sada procitana niska u skladu sa zadatim regularnim izrazom */
module fsa(in, clk, out);
   input in, clk;
   output out;
   reg [2:0]  state;

   /* out je jednak 1 akko je stanje SUCCESS */
   assign out = state == `SUCCESS ? 1 : 0;

   /* Pocetno stanje je START */
   initial
     state <= `START;

   /* Glavni proces implementira konacni automat */
   always @(posedge clk)
     begin
	case(state)
	  `START, `SUCCESS:
	    if(in) state <= `ONE;
	    else state <= `ZERO;
	  `ONE:
	    if(in) state <= `SUCCESS;
	    else state <= `ERROR;
	  `ZERO:
	    if(in) state <= `ERROR;
	    else state <= `SUCCESS;
	  `ERROR:
	    ;
	  endcase
     end

endmodule // fsa
