#include <iostream>
#include <vector>
#include <cstdlib>
#include <iomanip>

using namespace std;

/*
  Variable: p_i,j,k (ima znacenje da polje (i,j) ima vrednost k;

 \/_k  p_i,j,k za svako i,j

 ~p_i,j,k_1 \/ ~p_i,j,k_2  za k_1 != k_2 za svako i,j

 ~p_i,j_1,k \/ ~p_i,j_2,k   za j_1 != j_2, za svako i, k

 ~p_i_1,j,k \/ ~p_i_2,j,k  za i_1 != i_2, za svako j, k

 ~p_i_1,j_1,k \/ ~p_i_2,j_2,k gde (i_1,j_1) i (i_2,j_2) pripadaju istom
 kvadratu, za svako k

 ako je dato da polje (i,j) ima vrednost k, tada dodajemo jedinicnu klauzu:
 
 p_i,j,k

 */

unsigned varNumber(unsigned n, unsigned i, unsigned j, unsigned k)
{
  /* Varijable se nabrajaju u sledecem redosledu:
     p_1,1,1, p_1,1,2, p_1,1,3,...,p_1,2,1, p_1,2,2, ...,p_2,1,1, p_2,1,2,...*/

  unsigned n_2 = n * n;

  return n_2*n_2*i + n_2*j + k + 1;
}

void getFieldValue(unsigned var, 
		   unsigned n, 
		   unsigned & i, unsigned & j, unsigned & k)
{
  unsigned n_2 = n * n;
  var--;
  
  i = var / (n_2 * n_2);
  var = var % (n_2 * n_2);
  j = var / n_2;
  var = var % n_2;
  k = var;
}


typedef vector< vector<unsigned> > Sudoku;



Sudoku readSudoku(unsigned n, istream & istr)
{
  unsigned n_2 = n * n;
  Sudoku sudoku;

  for(unsigned i = 0; i < n_2; i++)
    {
      sudoku.push_back(vector<unsigned>(n_2));
      for(unsigned j = 0; j < n_2; j++)
	istr >> sudoku[i][j];
    }

  

  return sudoku;
}

typedef vector<int> Clause;

void printClause(const Clause & c, ostream & ostr)
{
  for(unsigned i = 0; i < c.size(); i++)
    ostr << c[i] << " ";
  ostr << 0 << endl;
}

void generateFormula(const Sudoku & sudoku, unsigned n, ostream & ostr)
{
  unsigned n_2 = n * n;
  vector<Clause> clauses;
  
  //   \/_k  p_i,j,k za svako i,j
  for(unsigned i = 0; i < n_2; i++)
    for(unsigned j = 0; j < n_2; j++)
      {
	Clause c;
	for(unsigned k = 0; k < n_2; k++)
	  c.push_back(varNumber(n, i, j, k));
	clauses.push_back(c);
      }

  // ~p_i,j,k_1 \/ ~p_i,j,k_2  za k_1 != k_2 za svako i,j
  for(unsigned i = 0; i < n_2; i++)
    for(unsigned j = 0; j < n_2; j++)
      for(unsigned k1 = 0; k1 < n_2; k1++)
	for(unsigned k2 = k1 + 1; k2 < n_2; k2++)
	  {
	    Clause c;
	    c.push_back(-varNumber(n,i,j,k1));
	    c.push_back(-varNumber(n,i,j,k2));
	    clauses.push_back(c);
	  }
  
  // ~p_i,j_1,k \/ ~p_i,j_2,k   za j_1 != j_2, za svako i, k
  for(unsigned i = 0; i < n_2; i++)
    for(unsigned k = 0; k < n_2; k++)
      for(unsigned j1 = 0; j1 < n_2; j1++)
	for(unsigned j2 = j1 + 1; j2 < n_2; j2++)
	  {
	    Clause c;
	    c.push_back(-varNumber(n,i,j1,k));
	    c.push_back(-varNumber(n,i,j2,k));
	    clauses.push_back(c);
	  }
 
  // ~p_i_1,j,k \/ ~p_i_2,j,k  za i_1 != i_2, za svako j, k
  for(unsigned j = 0; j < n_2; j++)
    for(unsigned k = 0; k < n_2; k++)
      for(unsigned i1 = 0; i1 < n_2; i1++)
	for(unsigned i2 = i1 + 1; i2 < n_2; i2++)
	  {
	    Clause c;
	    c.push_back(-varNumber(n,i1,j,k));
	    c.push_back(-varNumber(n,i2,j,k));
	    clauses.push_back(c);
	  }

  
  // ~p_i_1,j_1,k \/ ~p_i_2,j_2,k gde (i_1,j_1) i (i_2,j_2) pripadaju istom
  // kvadratu, za svako k
  for(unsigned k = 0; k < n_2; k++)
    for(unsigned i = 0; i < n; i++)
      for(unsigned j = 0; j < n; j++)	
	for(unsigned i1 = i * n; i1 < i * n + n; i1++)
	  for(unsigned j1 = j * n; j1 < j * n + n; j1++)
	    for(unsigned i2 = i1; i2 < i * n + n; i2++)
	      for(unsigned j2 = (i1 == i2 ? j1 + 1 : j * n); j2 < j * n + n; j2++)
		{
		  Clause c;
		  c.push_back(-varNumber(n,i1,j1,k));
		  c.push_back(-varNumber(n,i2,j2,k));
		  clauses.push_back(c);
		}

  
  // date vrednosti
  for(unsigned i = 0; i < n_2; i++)
    for(unsigned j = 0; j < n_2; j++)
      if(sudoku[i][j] != 0)
	{
	  Clause c;
	  c.push_back(varNumber(n, i, j, sudoku[i][j] - 1));
	  clauses.push_back(c);
	}

  ostr << "c Sudoku of size: " << n << endl;
  ostr << "p cnf " << n_2 * n_2 * n_2 << " " << clauses.size() << endl; 
  for(unsigned i = 0; i < clauses.size(); i++)
    printClause(clauses[i], ostr);
}

Sudoku generateSudoku(unsigned n, istream & istr)
{
  string s;
  unsigned n_2 = n * n;
  istr >> s;

  if(s == "SAT")
    {
      Sudoku sudoku;
      for(unsigned i = 0; i < n_2; i++)
	sudoku.push_back(vector<unsigned>(n_2));

      int l;
      istr >> l;
      while(l != 0)
	{
	  if(l > 0)
	    {
	      unsigned i, j, k;
	      getFieldValue(l, n, i, j, k);
	      sudoku[i][j] = k + 1;
	    }
	  istr >> l;
	}
      return sudoku;
    }
  else throw "UNSATISFIABLE";
}


bool checkRow(const Sudoku & sudoku, unsigned n, unsigned i)
{
  unsigned n_2 = n * n;
  vector<bool> elements(n_2, false);
  
  for(unsigned j = 0; j < n_2; j++)
    if(sudoku[i][j] == 0)
      continue;
    else if(elements[sudoku[i][j] - 1] == true)
      return false;
    else
      elements[sudoku[i][j] - 1] = true;
  
  return true; 
}
  
bool checkColumn(const Sudoku & sudoku, unsigned n, unsigned j) 
{
  unsigned n_2 = n * n;
  vector<bool> elements(n_2, false);
  
  for(unsigned i = 0; i < n_2; i++)
    if(sudoku[i][j] == 0)
      continue;
    else if(elements[sudoku[i][j] - 1] == true)
      return false;
    else
      elements[sudoku[i][j] - 1] = true;
  
  return true; 
}

bool checkSquare(const Sudoku & sudoku, unsigned n, unsigned k) 
  {
    unsigned n_2 = n * n;
    vector<bool> elements(n_2, false);
    
    for(unsigned i = 0; i < n; i++)
      for(unsigned j = 0; j < n; j++)
	if(sudoku[(k / n) * n + i][(k % n) * n + j] == 0)
	  continue;
	else if(elements[sudoku
			 [(k / n) * n + i]
			 [(k % n) * n + j] - 1] == true)
	  return false;
	else
	  elements[sudoku
		   [(k / n) * n + i]
		   [(k % n) * n + j] - 1] = true;
    
    return true;
  }
 



bool checkSudoku(const Sudoku & sudoku, unsigned n)
{
  unsigned n_2 = n * n;
  for(unsigned i = 0; i < n_2; i++)
    {
      if(checkRow(sudoku, n, i) == false ||
	 checkColumn(sudoku, n, i) == false ||
	 checkSquare(sudoku, n, i) == false)
	return false;
    }
  return true;
}

void printSudoku(const Sudoku & sudoku, ostream & ostr)
{
  for(unsigned i = 0; i < sudoku.size(); i++)
    {
      for(unsigned j = 0; j < sudoku[i].size(); j++)
	ostr << setw(2) << sudoku[i][j] << " ";
      ostr << endl;
    }
}

int main(int argc, char ** argv)
{
  if(argc < 2)
    {
      cerr << "usage: " << argv[0] << " [dim] (1|2)" << endl;
      exit(1);
    }

  unsigned n = atoi(argv[1]);
  
  if(atoi(argv[2]) == 1)
    {
      Sudoku sudoku = readSudoku(n, cin);      
      generateFormula(sudoku, n, cout);
    }
  else
    {
      Sudoku sudoku  = generateSudoku(n, cin);
      if(!checkSudoku(sudoku, n))
	{
	  cerr << "FATAL ERROR!! Sudoku not valid!!" << endl;
	  exit(1);
	}
      printSudoku(sudoku, cout);
    }
    
  return 0;
}
