;
; Primer formule koja izrazava tvrdjenje koje bi se na jeziku
; aritmetike mogla iskazati ovako:
;
; x < y /\ ~(x + z < y + z)
;
; U teoriji aritmetike ova formula je svakako nezadovoljiva.
; Medjutim, u teoriji bitvektora, usled prekoracenja moze se
; dogoditi da formula ipak vazi (npr, za x = 11111100,
; y = 11111111, z = 00000011).

(set-logic QF_BV)
(declare-fun x () (_ BitVec 8))
(declare-fun y () (_ BitVec 8))
(declare-fun z () (_ BitVec 8))
(assert
  (and
    (bvult x y)
    (not (bvult (bvadd x z) (bvadd y z)))
  )
)
(check-sat)
(get-value (x y z))
(exit)
