.intel_syntax noprefix

.text
.global periodic

##########################################################################
##
## Funkcija:
##
## int periodic(int * a, int n);
##
## ispituje da li je niz duzine n na koji pokazuje pokazivac a periodican,
## i vraca duzinu najmanjeg perioda ukoliko jeste periodican, a 0 u suprotnom.
## Argumenti funkcije su:
##
## -- int * a -- [ebp+8]  -- adresa pocetnog elementa niza
## -- int n   -- [ebp+12] -- duzina niza
##
###########################################################################
periodic:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

	## Ideja algoritma: pomocna funkcija periodic_k (vidi dole) ispituje
	## da li je dati niz periodican sa periodom k. Vraca 1 ako jeste,
	## a 0 u suprotnom. Funkcija periodic ce proci kroz sve moguce
	## periode k = 1, ... n/2 i za svaki ce redom pozivati pomocnu
	## funkciju, dok se ne naidje na prvi period niza.
	
	## U registru edx cemo cuvati n/2, tj. maksimalni period.
	mov ebx, [ebp + 12]
	sar ebx, 1

	## U registru esi cemo cuvati adresu pocetka niza.
	mov esi, [ebp + 8]

	
	## Pocinjemo sa periodom 1.
	mov edi, 1
	
next_period:
	## Dokle god je tekuci period manji od n/2
	cmp edi, ebx
	ja last_period

	## Pozivamo periodic_k(a, n, k), gde je k = edi
	push edi
	push dword ptr [ebp + 12]
	push esi
	call periodic_k
	add esp, 12

	## Ako funkcija vrati 1, znaci da je periodicna sa periodom edi.
	cmp eax, 1
	je found_period

	## Uvecavamo period i prelazimo na sledecu iteraciju.
	inc edi
	jmp next_period
last_period:	

	xor eax, eax
	jmp done
	
found_period:
	mov eax, edi

done:	
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret

##
## Pomocna funkcija:
##
## int periodic_k(int * a, int n, int k)
##
## koja proverava da li je niz a duzine n periodican sa
## periodom k. Vraca 1 ako jeste, a 0 ako nije. Argumenti:
##
## -- int * a -- [ebp + 8] -- adresa pocetnog elementa niza
## -- int n -- [ebp + 12] -- duzina niza
## -- int k -- [ebp + 16] -- duzina perioda
periodic_k:
	enter 0, 0
	push edi
	push esi
	push ebx

	## Ideja algoritma: prolazimo redom kroz niz sa dva indeksa -- jedan
	## se krece od 0 do n - 1, a drugi se ciklicno krece od 0  do k - 1.
	## U svakoj iteraciji uporedjujemo tekuce elemente na ta dva indeksa
	## i ako se na bilo kojoj poziciji javi neslaganje, niz nije
	## periodican sa datim periodom k. 

	## Registar ecx ce biti osnovni indeks u petlji (krece se od 0 do
	## n - 1).
	xor ecx, ecx

	## Registar ebx ce biti brojac sa modulom k (krece se od 0 do k - 1,
	## ciklicno).
	xor ebx, ebx

	## Registar esi ce cuvati adresu pocetka niza.
	mov esi, [ebp + 8]

	## Registar edi ce cuvati duzinu niza n.
	mov edi, [ebp + 12]

	## Registar edx ce cuvati duzinu perioda k
	mov edx, [ebp + 16]
	
next_element:
	## Poredimo indeks sa n
	cmp ecx, edi
	jge last_element

	## Ucitavamo tekuci element sa indeksom ecx
	mov eax, [esi + 4 * ecx]

	## Uporedjujemo ucitani element sa elementom na poziciji ebx, i ako
	## nisu jednaki, to znaci da niz nije periodican sa periodom k.
	cmp eax, [esi + 4 * ebx]
	jne failure
	
	
	## Uvecavamo brojac
	inc ecx

	## Uvecavamo brojac sa modulom k. Ako je nakon uvecanja brojac
	## jednak k, tada ga postavljamo na 0.
	inc ebx
	cmp ebx, edx
	je reset
	jmp skip
reset:
	xor ebx, ebx
skip:	
	jmp next_element
last_element:	

success:
	mov eax, 1
	jmp done_k
	
failure:
	xor eax, eax
	
done_k:	
	pop ebx
	pop esi
	pop edi
	leave
	ret