.text
.align 2


.global perfect

@ Funkcija:
@
@ int perfect(int n);
@ 
@ ispituje da li je broj n savrsen (tj. da li je zbir njegovih pravih 
@ delilaca jednak njemu samom). Argument funkcije je:
@
@ int n -- r0 --  dati broj n.
@
perfect:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koje cemo da koristimo.
	stmfd sp!, {r4-r6} 
	
	@ Registar r4 ce sadrzati tekuci broj  k za koji ispitujemo 
	@ da li je delilac broja n (inicijalno 1).
	mov r4, #1

	@ Registar r5 ce cuvati broj n.
	mov r5, r0

	@ Registar r6 ce cuvati zbir pravih delilaca.
	mov r6, #0

next_number:
	@ Dokle god je k < n
	cmp r4, r5
	beq last_number
	
	@ Odredjujemo ostatak n % k 
	mov r0, r5
	mov r1, r4
	bl __modsi3
	
	@ Ako je n % k == 0, dodajemo k na sumu delilaca.
	cmp r0, #0
	addeq r6, r6, r4 

	@ Uvecavamo k za jedan i prelazimo na sledecu iteraciju.
	add r4, r4, #1
	b next_number
last_number:

	@ Ako je zbir delilaca jednak broju n, vracamo 1.
	cmp r6, r5
	moveq r0, #1
	@ U suprotnom, vracamo 0.
	movne r0, #0
	

	@ Skidamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}

