.intel_syntax noprefix
	
.text
.global linear3
#############################################################################
##
## Funkcija:
##
## void linear3(double * a, double * b, double * x);
##
## racuna resenje linearnog sistema jednacina 3 x 3. Koeficienti sistema
## dati su jednodimenzionim nizom a duzine 9 (redom, po vrstama), a
## koeficienti slobodnih clanova dati su nizom b duzine 3. Resenje se
## upisuje u niz x (duzine 3). Pretpostavlja se da sistem ima jedinstveno
## resenje. Resenje se odredjuje Kramerovim pravilom.
## 
## -- double * a --  [ebp+8] -- adresa niza koeficienata.
## -- double * b --  [ebp+12] -- adresa niza slobodnih clanova.
## -- double * x --  [ebp+16] -- adresa niza u koji se upisuje rezultat
##
############################################################################ 
linear3:
        ## Prolog funkcije.
        enter	0, 0
	push ebx
	push edi
	push esi
	
	## U registar esi ucitavamo adresu niza koeficienata sistema.
	mov esi, [ebp + 8]

	## U registar edi ucitavamo adresu niza slobodnih clanova.
	mov edi,[ebp + 12]

	## U registar ebx ucitavamo adresu niza u koji se upisuje rezultat.
	mov ebx, [ebp + 16]
	
	## Racunamo determinantu sistema D.
	##      | a11   a12   a13 |
	##      |                 |
	##  D = | a21   a22   a23 |
	##      |	          |
	##      | a31   a32   a33 |
	##
	fld qword ptr [esi]          ## a11
	fmul qword ptr [esi + 32]    ## a11*a22
	fmul qword ptr [esi + 64]    ## a11*a22*a33=S1
	fld qword ptr [esi + 8]      ## S1,a12
	fmul qword ptr [esi + 40]    ## S1,a12*a23
	fmul qword ptr [esi + 48]    ## S1,a12*a23*a31=S2
	faddp st(1), st(0)	     ## S1+S2
	fld qword ptr [esi + 16]     ## S1+S2,a13
	fmul qword ptr [esi + 24]    ## S1+S2,a13*a21
	fmul qword ptr [esi + 56]    ## S1+S2,a13*a21*a32=S3
	faddp st(1), st(0)	     ## S1+S2+S3
	fld qword ptr [esi + 48]     ## S1+S2+S3,a31
	fmul qword ptr [esi + 32]    ## S1+S2+S3,a31*a22
	fmul qword ptr [esi + 16]    ## S1+S2+S3,a31*a22*a13=P1
	fsubp st(1), st(0)	     ## S1+S2+S3-P1
	fld qword ptr [esi + 56]     ## S1+S2+S3-P1,a32
	fmul qword ptr [esi + 40]    ## S1+S2+S3-P1,a32*a23
	fmul qword ptr [esi]         ## S1+S2+S3-P1,a32*a23*a11=P2
	fsubp st(1), st(0) 	     ## S1+S2+S3-P1-P2
	fld qword ptr [esi + 64]     ## S1+S2+S3-P1-P2,a33
	fmul qword ptr [esi + 24]    ## S1+S2+S3-P1-P2,a33*a21
	fmul qword ptr [esi + 8]     ## S1+S2+S3-P1-P2,a33*a21*a12=P3
	fsubp st(1), st(0)	     ## S1+S2+S3-P1-P2-P3 = D

	## Racunamo determinantu D1
	##       | b1   a12   a13 |
	##       |                |
	##  D1 = | b2   a22   a23 |
	##       |    	          |
	##       | b3   a32   a33 |
	##
	fld qword ptr [edi]          ## D, b1
	fmul qword ptr [esi + 32]    ## D, b1*a22
	fmul qword ptr [esi + 64]    ## D, b1*a22*a33=S1
	fld qword ptr [esi + 8]      ## D, S1,a12
	fmul qword ptr [esi + 40]    ## D, S1,a12*a23
	fmul qword ptr [edi + 16]    ## D, S1,a12*a23*b3=S2
	faddp st(1), st(0)	     ## D, S1+S2
	fld qword ptr [esi + 16]     ## D, S1+S2,a13
	fmul qword ptr [edi + 8]     ## D, S1+S2,a13*b2
	fmul qword ptr [esi + 56]    ## D, S1+S2,a13*b2*a32=S3
	faddp st(1), st(0)	     ## D, S1+S2+S3
	fld qword ptr [edi + 16]     ## D, S1+S2+S3,b3
	fmul qword ptr [esi + 32]    ## D, S1+S2+S3,b3*a22
	fmul qword ptr [esi + 16]    ## D, S1+S2+S3,b3*a22*a13=P1
	fsubp st(1), st(0)	     ## D, S1+S2+S3-P1
	fld qword ptr [esi + 56]     ## D, S1+S2+S3-P1,a32
	fmul qword ptr [esi + 40]    ## D, S1+S2+S3-P1,a32*a23
	fmul qword ptr [edi]         ## D, S1+S2+S3-P1,a32*a23*b1=P2
	fsubp st(1), st(0) 	     ## D, S1+S2+S3-P1-P2
	fld qword ptr [esi + 64]     ## D, S1+S2+S3-P1-P2,a33
	fmul qword ptr [edi + 8]     ## D, S1+S2+S3-P1-P2,a33*b2
	fmul qword ptr [esi + 8]     ## D, S1+S2+S3-P1-P2,a33*b2*a12=P3
	fsubp st(1), st(0)	     ## D, S1+S2+S3-P1-P2-P3 = D1

	## Racunamo determinantu D2
	##       | a11   b1   a13 |
	##       |                |
	##  D2 = | a21   b2   a23 |
	##       |       	  |
	##       | a31   b3   a33 |
	##
	fld qword ptr [esi]          ## D, D1, a11
	fmul qword ptr [edi + 8]     ## D, D1, a11*b2
	fmul qword ptr [esi + 64]    ## D, D1, a11*b2*a33=S1
	fld qword ptr [edi]          ## D, D1, S1,b1
	fmul qword ptr [esi + 40]    ## D, D1, S1,b1*a23
	fmul qword ptr [esi + 48]    ## D, D1, S1,b1*a23*a31=S2
	faddp st(1), st(0)	     ## D, D1, S1+S2
	fld qword ptr [esi + 16]     ## D, D1, S1+S2,a13
	fmul qword ptr [esi + 24]    ## D, D1, S1+S2,a13*a21
	fmul qword ptr [edi + 16]    ## D, D1, S1+S2,a13*a21*b3=S3
	faddp st(1), st(0)	     ## D, D1, S1+S2+S3
	fld qword ptr [esi + 48]     ## D, D1, S1+S2+S3,a31
	fmul qword ptr [edi + 8]     ## D, D1, S1+S2+S3,a31*b2
	fmul qword ptr [esi + 16]    ## D, D1, S1+S2+S3,a31*b2*a13=P1
	fsubp st(1), st(0)	     ## D, D1, S1+S2+S3-P1
	fld qword ptr [edi + 16]     ## D, D1, S1+S2+S3-P1,b3
	fmul qword ptr [esi + 40]    ## D, D1, S1+S2+S3-P1,b3*a23
	fmul qword ptr [esi]         ## D, D1, S1+S2+S3-P1,b3*a23*a11=P2
	fsubp st(1), st(0) 	     ## D, D1, S1+S2+S3-P1-P2
	fld qword ptr [esi + 64]     ## D, D1, S1+S2+S3-P1-P2,a33
	fmul qword ptr [esi + 24]    ## D, D1, S1+S2+S3-P1-P2,a33*a21
	fmul qword ptr [edi]         ## D, D1, S1+S2+S3-P1-P2,a33*a21*b1=P3
	fsubp st(1), st(0)	     ## D, D1, S1+S2+S3-P1-P2-P3 = D2
	

	## Racunamo determinantu D3.
	##       | a11   a12   b1 |
	##       |                |
	##  D3 = | a21   a22   b2 |
	##       |	          |
	##       | a31   a32   b3 |
	##
	fld qword ptr [esi]          ## D, D1, D2, a11
	fmul qword ptr [esi + 32]    ## D, D1, D2, a11*a22
	fmul qword ptr [edi + 16]    ## D, D1, D2, a11*a22*b3=S1
	fld qword ptr [esi + 8]      ## D, D1, D2, S1,a12
	fmul qword ptr [edi + 8]     ## D, D1, D2, S1,a12*b2
	fmul qword ptr [esi + 48]    ## D, D1, D2, S1,a12*b2*a31=S2
	faddp st(1), st(0)	     ## D, D1, D2, S1+S2
	fld qword ptr [edi]          ## D, D1, D2, S1+S2,b1
	fmul qword ptr [esi + 24]    ## D, D1, D2, S1+S2,b1*a21
	fmul qword ptr [esi + 56]    ## D, D1, D2, S1+S2,b1*a21*a32=S3
	faddp st(1), st(0)	     ## D, D1, D2, S1+S2+S3
	fld qword ptr [esi + 48]     ## D, D1, D2, S1+S2+S3,a31
	fmul qword ptr [esi + 32]    ## D, D1, D2, S1+S2+S3,a31*a22
	fmul qword ptr [edi]         ## D, D1, D2, S1+S2+S3,a31*a22*b1=P1
	fsubp st(1), st(0)	     ## D, D1, D2, S1+S2+S3-P1
	fld qword ptr [esi + 56]     ## D, D1, D2, S1+S2+S3-P1,a32
	fmul qword ptr [edi + 8]     ## D, D1, D2, S1+S2+S3-P1,a32*b2
	fmul qword ptr [esi]         ## D, D1, D2, S1+S2+S3-P1,a32*b2*a11=P2
	fsubp st(1), st(0) 	     ## D, D1, D2, S1+S2+S3-P1-P2
	fld qword ptr [edi + 16]     ## D, D1, D2, S1+S2+S3-P1-P2,b3
	fmul qword ptr [esi + 24]    ## D, D1, D2, S1+S2+S3-P1-P2,b3*a21
	fmul qword ptr [esi + 8]     ## D, D1, D2, S1+S2+S3-P1-P2,b3*a21*a12=P3
	fsubp st(1), st(0)	     ## D, D1, D2, S1+S2+S3-P1-P2-P3 = D3

	## Racunamo resenje po kramerovom pravilu i smestamo ga u niz x.
	fdiv st(0), st(3)	     ## D, D1, D2, D3/D=x3
	fstp qword ptr [ebx + 16]    ## D, D1, D2
	fdiv st(0), st(2)	     ## D, D1, D2/D=x2
	fstp qword ptr [ebx + 8]     ## D, D1
	fdiv st(0), st(1)            ## D, D1/D=x1
	fstp qword ptr [ebx]         ## D
	fcomp		             ##
	
        ## Epilog funkcije.
	pop esi
	pop edi
	pop ebx
        leave
        ret
