﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;
using System.Data.Entity.Core.Objects;

namespace StoredProc
{
    class Program
    {
        static void Main(string[] args)
        {
            DVDClubEntities entities = new DVDClubEntities();

            var customerLeases = from cl in entities.showLeases()
                                 select
                                 new
                                 {
                                     cl.FirstName,
                                     cl.LastName,
                                     MovieName = cl.Name,
                                     cl.LeaseDate
                                 };

            foreach (var cl in customerLeases)
                Console.WriteLine(cl);

            ObjectParameter p = new ObjectParameter("Result", 0);
            entities.averageLeasesNumber(p);
            Console.WriteLine(p.Value);

            ObjectParameter customerID = new ObjectParameter("CustomerID", 0);
            ObjectParameter leaseNumber = new ObjectParameter("LeaseNumber", 0);
            entities.mostActiveCustomer(new DateTime(2011, 10, 11), customerID, leaseNumber);
            Console.WriteLine("Customer: {0}, LeaseNumber: {1}", customerID.Value, leaseNumber.Value);

            var result = from e in entities.movieLeaseCount(DateTime.Parse("2001/01/01"))
                         join m in entities.Movies on e.MovieID equals m.ID
                         select new { m.ID, m.Name, e.LeaseCount };

            foreach (var r in result)
                System.Console.WriteLine(r);

            var result2 = from e in entities.movieLeaseCountFunc(DateTime.Parse("2001/01/01"))
                         join m in entities.Movies on e.MovieID equals m.ID
                         select new { m.ID, m.Name, e.LeaseCount };

            foreach (var r in result2)
                System.Console.WriteLine(r);
                         
        }
    }
}

