USE DVDClub;
GO

IF OBJECT_ID('showLeases', 'P') IS NOT NULL
BEGIN
DROP PROCEDURE showLeases;
PRINT 'Dropped showLeases';
END
GO

CREATE PROCEDURE showLeases
AS
SELECT Movie.Name, Customer.FirstName, Customer.LastName, Lease.LeaseDate 
FROM Lease JOIN Movie ON Movie.ID = Lease.MovieID 
JOIN Customer ON Lease.CustomerID = Customer.ID;
GO
PRINT 'Created showLeases';
GO

IF OBJECT_ID('movieLeaseCount', 'P') IS NOT NULL 
BEGIN
DROP PROCEDURE movieLeaseCount;
PRINT 'Dropped movieLeaseCount';
END
GO

CREATE PROCEDURE movieLeaseCount
(
   @StartDate DATE 
)
AS
 SELECT MovieID, COUNT(*) AS LeaseCount
 FROM Lease
 WHERE LeaseDate >= @StartDate
 GROUP BY MovieID
GO
PRINT 'Created movieLeaseCount';
GO

IF OBJECT_ID('averageLeasesNumber', 'P') IS NOT NULL
BEGIN
DROP PROCEDURE averageLeasesNumber;
PRINT 'Dropped averageLeasesNumber';
END
GO

CREATE PROCEDURE averageLeasesNumber
(
  @Result DOUBLE PRECISION OUTPUT
)
AS
WITH CountLeases (CustomerID, Cnt)
AS
(SELECT CustomerID, COUNT(*) AS Cnt 
FROM Lease 
GROUP BY Lease.CustomerID)
SELECT @Result = AVG(0.0 + Cnt)
FROM CountLeases;
GO
PRINT 'Created averageLeasesNumber';
GO

IF OBJECT_ID('mostActiveCustomer', 'P') IS NOT NULL
BEGIN
DROP PROCEDURE mostActiveCustomer;
PRINT 'Dropped mostActiveCustomer';
END
GO

CREATE PROCEDURE mostActiveCustomer
(
   @StartDate DATE,
   @CustomerID INTEGER OUTPUT,
   @LeaseNumber INTEGER OUTPUT
)
AS
DECLARE @TableVar AS TABLE 
(
   CustomerID INTEGER,
   LeaseNumber INTEGER
);

INSERT INTO @TableVar
SELECT CustomerID, COUNT(*)
FROM Lease 
WHERE LeaseDate >= @StartDate 
GROUP BY CustomerID

SELECT TOP(1) @CustomerID = CustomerID, @LeaseNumber = LeaseNumber 
FROM @TableVar
ORDER BY LeaseNumber DESC;
GO
PRINT 'Created mostActiveCustomer';
GO

IF OBJECT_ID('movieLeaseCountFunc', 'IF') IS NOT NULL 
BEGIN
DROP FUNCTION movieLeaseCountFunc;
PRINT 'Dropped movieLeaseCountFunc';
END
GO

CREATE FUNCTION movieLeaseCountFunc
(
   @StartDate DATE 
)
RETURNS TABLE
RETURN SELECT MovieID, COUNT(*) AS LeaseCount
 FROM Lease
 WHERE LeaseDate >= @StartDate
 GROUP BY MovieID
GO
PRINT 'Created movieLeaseCountFunc';
GO