﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Linq
{
    class Program
    {
        static void Main(string[] args)
        {
            using (DVDClubEntities entities = new DVDClubEntities())
            {
                // a)
                var moviesAfter2000 = from movie in entities.Movies
                                      where movie.Year > 2000
                                      select new
                                      {
                                          movie.Name,
                                          movie.Year,
                                          movie.Rating
                                      };

                foreach (var movie in moviesAfter2000)
                    Console.WriteLine(movie);

                // b)
                var movies2G = from movie in entities.Movies
                               where movie.Genres.Count() > 1
                               select new
                               {
                                   movie.Name,
                                   movie.Genres
                               };

                foreach (var movie in movies2G)
                {
                    Console.WriteLine(movie.Name);
                    foreach (var genre in movie.Genres)
                        Console.WriteLine("    " + genre.Name);
                }

                // b2)
                var movies2G2 = from m in entities.Movies
                                let Count = m.Genres.Count()
                                where Count > 1
                                orderby Count descending
                                select new
                                {
                                    m.Name,
                                    m.Year,
                                    Count
                                };

                foreach (var m in movies2G2)
                    Console.WriteLine(m);

                // c)
                var genresMovies = from genre in entities.Genres
                                   let MovieCount = genre.Movies.Count()
                                   orderby MovieCount descending
                                   select new
                                   {
                                       genre.Name,
                                       MovieCount
                                   };

                foreach (var genre in genresMovies)
                    Console.WriteLine(genre);

                // d)
                var customers = from customer in entities.Customers
                                where (from lease in entities.Leases
                                       where lease.CustomerID == customer.ID &&
                                             lease.LeaseDate.CompareTo(new DateTime(2011, 10, 1)) >= 0 &&
                                             lease.LeaseDate.CompareTo(new DateTime(2011, 11, 1)) < 0
                                       select lease.MovieID).Distinct().Count() > 1
                                select new
                                {
                                    customer.FirstName,
                                    customer.LastName
                                };

                // d2)
                var customers2 = from c in entities.Customers
                                 let MovieCount = (from lease in c.Leases // Navigation property
                                                   where lease.LeaseDate.Year == 2011 &&
                                                         lease.LeaseDate.Month == 10
                                                   select lease.MovieID).Distinct().Count()
                                 where MovieCount > 1
                                 orderby MovieCount descending
                                 select new
                                 {
                                     c.FirstName,
                                     c.LastName,
                                     MovieCount

                                 };
                foreach (var c in customers2)
                    Console.WriteLine(c);


                // d3)
                var customers3 = from lease in entities.Leases
                                 where lease.LeaseDate.CompareTo(new DateTime(2011, 10, 1)) >= 0 &&
                                       lease.LeaseDate.CompareTo(new DateTime(2011, 11, 1)) < 0
                                 select new
                                 {
                                     lease.CustomerID,
                                     lease.MovieID
                                 }
                                     into customer_movie
                                     group customer_movie by customer_movie.CustomerID
                                         into customer_group
                                         select new
                                         {
                                             CustomerID = customer_group.Key,
                                             CountMovies = customer_group.Distinct().Count()
                                         }
                                             into customer_count
                                             //from customer in entities.Customers
                                             //where customer_count.CustomerID == customer.ID
                                             join customer in entities.Customers
                                             on customer_count.CustomerID equals customer.ID
                                             where customer_count.CountMovies > 1
                                             orderby customer_count.CountMovies descending
                                             select new
                                             {
                                                 customer.FirstName,
                                                 customer.LastName,
                                                 customer_count.CountMovies
                                             };


                foreach (var customer in customers3)
                    Console.WriteLine(customer);

                // e)
                var adultCustomers = from customer in entities.Customers
                                     join lease in entities.Leases
                                     on customer.ID equals lease.CustomerID
                                     join movie in entities.Movies
                                     on lease.MovieID equals movie.ID
                                     where lease.LeaseDate.Year - customer.YearOfBirth > 18 &&
                                           (from genre in movie.Genres
                                            where genre.Name == "Animated" ||
                                                  genre.Name == "Cartoon"
                                            select genre).Any()
                                     select new
                                     {
                                         customer.ID,
                                         customer.FirstName,
                                         customer.LastName,
                                         customer.YearOfBirth,
                                         movie.Name,
                                         lease.LeaseDate
                                     };
                // e2)
                var adultCustomers2 = from lease in entities.Leases
                                      where lease.LeaseDate.Year - lease.Customer.YearOfBirth > 18 &&
                                           (from genre in lease.Movie.Genres
                                            where genre.Name == "Animated" ||
                                                  genre.Name == "Cartoon"
                                            select genre).Any()
                                      select new
                                      {
                                          lease.CustomerID,
                                          lease.Customer.FirstName,
                                          lease.Customer.LastName,
                                          lease.Customer.YearOfBirth,
                                          lease.Movie.Name,
                                          lease.LeaseDate
                                      };
                foreach (var customer in adultCustomers2)
                    Console.WriteLine(customer);

                // e3)
                var adultCustomers3 = from c in entities.Customers
                                      where (from lease in c.Leases
                                             where lease.LeaseDate.Year - c.YearOfBirth >= 18
                                             && (from g in lease.Movie.Genres
                                                 where g.Name == "Cartoon" ||
                                                       g.Name == "Animated"
                                                 select g).Any()
                                             select lease).Any()
                                      select new
                                      {
                                          c.FirstName,
                                          c.LastName
                                      };

                foreach (var c in adultCustomers3)
                    Console.WriteLine(c);

                // f) (previse komplikovano)
                var movieLeaseCount = from lease in entities.Leases
                                      group lease by lease.MovieID
                                          into lease_group
                                          let Count = lease_group.Count()
                                          orderby Count descending
                                          select new
                                          {
                                              MovieID = lease_group.Key,
                                              Count
                                          }
                                              into movie_count
                                              join movie in entities.Movies
                                              on movie_count.MovieID equals movie.ID
                                              orderby movie_count.Count ascending
                                              select new
                                                  {
                                                      MovieName = movie.Name,
                                                      movie_count.Count
                                                  };

                // f2) (jednostavno resenje, pomocu navigacionih svojstava)
                var movieLeaseCount2 = from movie in entities.Movies
                                       let Count = movie.Leases.Count()
                                       orderby Count ascending
                                       select new
                                       {
                                           MovieName = movie.Name,
                                           Count
                                       };

                foreach (var movie in movieLeaseCount2)
                    Console.WriteLine(movie);

                // g)
                double averageLeasedMoviesPerDay = (from lease in entities.Leases
                                                    select new
                                                    {
                                                        lease.LeaseDate,
                                                        lease.MovieID
                                                    }
                                                        into date_movie
                                                        group date_movie by date_movie.LeaseDate
                                                            into lease_group
                                                            select new
                                                            {
                                                                LeaseDate = lease_group.Key,
                                                                Count = lease_group.Distinct().Count()
                                                            }).Average(x => (double)x.Count);



                Console.WriteLine("Prosecan broj iznajmljivanja po danu: {0}", averageLeasedMoviesPerDay);

                // h)
                var comedyCustomers = from customer in entities.Customers
                                      where !(from movie in entities.Movies
                                              where (from genre in movie.Genres
                                                     where genre.Name == "Comedy"
                                                     select genre).Any()
                                              && !(from lease in customer.Leases
                                                   where movie.ID == lease.MovieID
                                                   select lease).Any()
                                              select movie).Any()
                                      select new
                                      {
                                          customer.FirstName,
                                          customer.LastName
                                      };

                foreach (var customer in comedyCustomers)
                    Console.WriteLine(customer);

                // Dodavanje novog entiteta:
                Customer newCustomer = new Customer { FirstName = "Miodrag", LastName = "Petrovic", YearOfBirth = 1946 };

                entities.Customers.Add(newCustomer);
                entities.SaveChanges();

                // Brisanje entiteta:
                Customer deletedCustomer = (from customer in entities.Customers
                                            where customer.FirstName == "Miodrag" &&
                                            customer.LastName == "Petrovic"
                                            select customer).First();

                entities.Customers.Remove(deletedCustomer);
                entities.SaveChanges();

                // U nastavku demonstriramo koriscenje transakcija. Ovo 
                // u ovom primeru nije neophodno, zato sto je svaki poziv
                // SaveChanges() sam po sebi jedna transakcija koja obuhvata
                // sve promene u bazi napravljene od poslednjeg poziva ove
                // metode. Medjutim, ako zelimo vise SaveChanges() poziva
                // da stavimo u jednu veliku transakciju, tada se koristi
                // ovakav mehanizam
                using(var transaction = entities.Database.BeginTransaction())
                {
                    try // pokusavamo da obavimo neke operacije na bazi
                    {
                        // Azuriranje entiteta:
                        var moviesHighRating = from movie in entities.Movies
                                               where movie.Rating > 1.5
                                               select movie;

                        foreach (var movie in moviesHighRating)
                            movie.Rating /= entities.Movies.Max(x => x.Rating);
                        entities.SaveChanges();

                        // ako prethodni kod ne izbaci izuzetak, tada
                        // pozivamo Commit();
                        transaction.Commit(); 
                    }
                    catch(Exception e)
                    {
                        // u suprotnom, pozivamo Rollback();
                        transaction.Rollback();
                    }
                }       
            }
        }
    }
}
