.intel_syntax noprefix

.text
.global takeuchi

#########################################################################
##
## Funkcija:
## int takeuchi(int x, int y, int z);
##
## implementira Takeucijevu funkciju za testiranje rekurzivnih poziva.
## Argumenti funkcije su:
##
## -- int x -- [ebp+8] - vrednost x
## -- int y -- [ebp+12] - vrednost y
## -- int z -- [ebp+16] - vrednost z
##
#########################################################################
takeuchi:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Argumenti funkcije x, y i z se drze respektivno u registrima
	## ebx, esi i edi.
        mov     ebx, [ebp+8]
        mov     esi, [ebp+12]
        mov     edi, [ebp+16]

        ## Obradjuje se nerekurzivni slucaj.
        cmp     esi, ebx
        jl recurse
        mov     eax, edi
        jmp done

recurse:
        ## Obavlja se rekurzivni poziv tak(z - 1, x, y).  Rezultat se
	## odmah stavlja na stek.
        push    esi
        push    ebx
        mov     eax, edi
        dec     eax
        push    eax
        call takeuchi
        add     esp, 12
        push    eax

        ## Obavlja se rekurzivni poziv tak(y - 1, z, x).  Rezultat se
	## odmah stavlja na stek.
        push    ebx
        push    edi
        mov     eax, esi
        dec     eax
        push    eax
        call takeuchi
        add     esp, 12
        push    eax

        ## Obavlja se rekurzivni poziv tak(x - 1, y, z).  Rezultat se
	## odmah stavlja na stek.
        push    edi
        push    esi
        mov     eax, ebx
        dec     eax
        push    eax
        call takeuchi
        add     esp, 12
        push    eax

        ## Obavlja se finalni rekurzivni poziv.  Argumenti ovog poziva
	## su vec pripremljeni na steku.
        call takeuchi
        add     esp, 12

        ## Formira se rezultat funkcije.
        inc     eax

done:        
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret
