.intel_syntax noprefix
        
.text
.global secant
############################################################################
##
## Funkcija:
## double secant(double a, double b, double epsilon);
##
## odredjuje nulu funkcije f(x)=sin(x)-x*cos(x) metodom secice.
## Argumenti funkcije su:
##
## -- double a -- [ebp+8] -- leva granica intervala
## -- double b -- [ebp+16] -- desna granica intervala
## -- double epsilon -- [ebp+24] -- zeljena tacnost
##
## Funkcija vraca nadjenu nulu funkcije f(x) kao povratnu vrednost.
##
############################################################################
secant:
        ## Prolog funkcije.
	enter   0, 0

        ## Na stek se ucitavaju zeljena tacnost i vrednost x[0]=b.
        fld  qword ptr [ebp+24]   # Stek: eps
        fld  qword ptr [ebp+16]   # Stek: eps, b=x[0]=x[n-1]

        ## Racuna se f(x[n-1]).
        fld  st                   # Stek: eps, x[n-1], x[n-1]
        fsincos                   # Stek: eps, x[n-1], sin(x[n-1]), cos(x[n-1])
        fmul st, st(2)            # Stek: eps, x[n-1], sin(x[n-1]), x[n-1]*cos(x[n-1])
        fsubp                     # Stek: eps, x[n-1], sin(x[n-1])-x[n-1]*cos(x[n-1])=f(x[n-1])

        ## Na stek se ucitava vrednost x[1]=a.
        fld qword ptr [ebp+8]     # Stek: eps, x[n-1], f(x[n-1]), a=x[1]=x[n]

again:
        ## Swap-uju se na steku x[n] i x[n-1].
        fxch st(2)                # Stek: eps, x[n], f(x[n-1]), x[n-1]

        ## Racuna se f(x[n]).
        fld st(2)                 # Stek: eps, x[n], f(x[n-1]), x[n-1], x[n]
        fsincos                   # Stek: eps, x[n], f(x[n-1]), x[n-1], sin(x[n]), cos(x[n])
        fmul st, st(4)            # Stek: eps, x[n], f(x[n-1]), x[n-1], sin(x[n]), x[n]*cos(x[n])
        fsubp                     # Stek: eps, x[n], f(x[n-1]), x[n-1], sin(x[n])-x[n]*cos(x[n])=f(x[n])

        ## Swap-uju se na steku f(x[n]) i f(x[n-1])
        fxch st(2)                # Stek: eps, x[n], f(x[n]), x[n-1], f(x[n-1])

        ## Racuna se x[n+1].
        fsub st, st(2)            # Stek: eps, x[n], f(x[n]), x[n-1], f(x[n-1])-f(x[n])
        fdivr st, st(2)           # Stek: eps, x[n], f(x[n]), x[n-1], f(x[n])/(f(x[n-1])-f(x[n]))
        fxch st(1)                # Stek: eps, x[n], f(x[n]), f(x[n])/(f(x[n-1])-f(x[n])), x[n-1]
        fsub st, st(3)            # Stek: eps, x[n], f(x[n]), f(x[n])/(f(x[n-1])-f(x[n])), x[n-1]-x[n]
        fmulp                     # Stek: eps, x[n], f(x[n]), f(x[n])/(f(x[n-1])-f(x[n]))*(x[n-1]-x[n])
        fsubr st, st(2)           # Stek: eps, x[n], f(x[n]), x[n]-f(x[n])/(f(x[n-1])-f(x[n]))*(x[n-1]-x[n])=x[n+1]

        ## Proverava se da li je postignuta zeljena tacnost; ako nije,
	## nastavlja se sa iteracijama.  Treba primetiti da je
        ## raspored vrednosti na steku isti na kraju svake iteracije
	## kao na njenom pocetku.
        fld st                    # Stek: eps, x[n], f(x[n]), x[n+1], x[n+1]
        fsub st, st(3)            # Stek: eps, x[n], f(x[n]), x[n+1], x[n+1]-x[n]
        fabs                      # Stek: eps, x[n], f(x[n]), x[n+1], abs(x[n+1]-x[n])
        fcomip st, st(4)          # Stek: eps, x[n], f(x[n]), x[n+1]
        jae again

        ## Skidaju se nepotrebne vrednosti sa steka.
        fxch  st(3)               # Stek: x[n+1], x[n], f(x[n]), eps
        ffree  st                 # Stek: x[n+1], x[n], f(x[n]), invalidna vrednost
        fincstp                   # Stek: x[n+1], x[n], f(x[n])
        ffree   st                # Stek: x[n+1], x[n], invalidna vrednost
        fincstp                   # Stek: x[n+1], x[n]
        ffree   st                # Stek: x[n+1], invalidna vrednost
        fincstp                   # Stek: x[n+1]
        
	## Epilog funkcije.
	leave
        ret
