.intel_syntax noprefix

.text
.global bmp2utf8
        
        ## Procedura bmp2utf8() odredjuje UTF-8 zapis za dati Unicode
	## karakter.  Argumenti funkcije su:
        ##   [ebp+8] - kod karaktera ciji se UTF-8 zapis odredjuje
        ##   [ebp+12] - adresa na koju treba upisati broj elemenata u
	##              UTF-8 zapisu datog karaktera
        ##   [ebp+16] - adresa memorijskog bloka u koji treba upisati
	##              UTF-8 zapis datog karaktera
        ## Pretpostavka je da dati karakter pripada BMP Unicode ravni
        ## odn. da je njegov kod u opsegu [0,2^16-1].  Funkcija se u
	## potpunosti podvrgava C konvencijama pozivanja.
bmp2utf8:
        ## Prolog funkcije.
        enter   0, 0
        push    edi

        ## U registar eax se ucitava Unicode kod datog karaktera, a u
        ## registar esi adresa na koju ce biti upisan prvi element UTF-8
	## zapisa istog.
        mov     eax, [ebp+8]
        mov     edi, [ebp+16]

        ## Izracunava se da li ce dati karakter biti predstavljen sa 1,
        ## 2 ili 3 elementa u UTF-8 zapisu i prelazi se na odgovarajuce
	## procesiranje.
        cmp     eax, 0x80
        jl one_byte
        cmp     eax, 0x800
        jl two_bytes
        jmp three_bytes

one_byte:
        ## Upisuje se prvi (i jedini) element UTF-8 zapisa datog
        ## karaktera u memoriju, a u registar ecx se upisuje duzina
	## UTF-8 zapisa.
        mov     [edi], eax
        mov     ecx, 1
        jmp store_count

two_bytes:
        ## Formira se i upisuje u memoriju prvi element UTF-8 zapisa
	## datog karaktera.
        mov     edx, eax
        and     edx, 0b11111000000
        shr     edx, 6
        or      edx, 0b11000000
        mov     [edi], edx
        add     edi, 4

        ## Formira se i upisuje u memoriju drugi element UTF-8 zapisa
	## datog karaktera.
        mov     edx, eax
        and     edx, 0b00111111
        or      edx, 0b10000000
        mov     [edi], edx

        ## U registar ecx se upisuje duzina UTF-8 zapisa.
        mov     ecx, 2
        jmp store_count

three_bytes:
        ## Formira se i upisuje u memoriju prvi element UTF-8 zapisa
	## datog karaktera.
        mov     edx, eax
        and     edx, 0b1111000000000000
        shr     edx, 12
        or      edx, 0b11100000
        mov     [edi], edx
        add     edi, 4

        ## Formira se i upisuje u memoriju drugi element UTF-8 zapisa
	## datog karaktera.
        mov     edx, eax
        and     edx, 0b111111000000
        shr     edx, 6
        or      edx, 0b10000000
        mov     [edi], edx
        add     edi, 4

        ## Formira se i upisuje u memoriju treci element UTF-8 zapisa
	## datog karaktera.
        mov     edx, eax
        and     edx, 0b00111111
        or      edx, 0b10000000
        mov     [edi], edx

        ## U registar ecx se upisuje duzina UTF-8 zapisa.
        mov     ecx, 3
        jmp store_count

store_count:
        ## Duzina UTF-8 zapisa datog karaktera se upisuje u memoriju.
        mov     edi, [ebp+12]
        mov     [edi], ecx
        
        ## Epilog funkcije.
        pop     edi
        leave
        ret
