.intel_syntax noprefix
	
.text
.global nth_root
#############################################################################
##
## Funkcija:
##
## double nth_root(double x, int n, double eps);
##
## racuna n-ti koren broja x vavilonskim metodom sa preciznoscu eps.
## U pitanju je iterativni metod x_{k+1} = 1/n*((n-1)x_k + x/x_k^(n-1)),
## pri cemu se za x_0 uzima proizvoljan broj (u nasem slucaju x_0 = 1).
## Iteracija se prekida kada je |x_{k+1} - x_k| < eps. Argumenti funkcije
## su:
## 
## -- double x 	 --  [ebp+8]  -- broj ciji se koren racuna
## -- int n      --  [ebp+16] -- koren koji racunamo
## -- double eps --  [ebp+20] -- trazena preciznost
##
############################################################################ 
nth_root:
        ## Prolog funkcije.
        enter	0, 0
	push ebx
	push edi
	push esi

	## Ucitavamo n - 1 u eax
	mov eax, [ebp + 16] 
	dec eax
	
	## Ucitavamo podatke na FPU stek. Vrednost x_0 se inicijalizuje na 1.
	fld  qword ptr [ebp+8]    ##stek: x
	fld  qword ptr [ebp+20]   ##stek: x,eps
	fild dword ptr [ebp+16]   ##stek: x,eps,n	
	fld1			  ##stek: x,eps,n,1 = x_k

next:
	## Izracunavamo x_{k+1} na osnovu x_k
	fld1			  ##stek: x,eps,n,x_k,1 = x_k^0

	## Petlja ce se izvrsiti n-1 put, u svakoj iteraciji ce se st(0)
	## mnoziti sa x_k.
	mov ecx, eax

				  ##stek: x,eps,n,x_k,x_k^0
	jecxz last_x
next_x:
	fmul st(0), st(1) 	  ##stek: x,eps,n,x_k,x_k^i
	loop next_x
last_x:	
				  ##stek: x,eps,n,x_k,x_k^{n-1}

	
	fdivr st(0), st(4)        ##stek: x,eps,n,x_k,x/x_k^{n-1}
	fld st(1)		  ##stek: x,eps,n,x_k,x/x_k^{n-1},x_k
	fld st(3)		  ##stek: x,eps,n,x_k,x/x_k^{n-1},x_k,n
	fld1			  ##stek: x,eps,n,x_k,x/x_k^{n-1},x_k,n,1
	fsubp			  ##stek: x,eps,n,x_k,x/x_k^{n-1},x_k,n-1
	fmulp			  ##stek: x,eps,n,x_k,x/x_k^{n-1},x_k*(n-1)
	faddp			  ##stek: x,eps,n,x_k,x/x_k^{n-1}+x_k*(n-1)
	
	fdiv st(0), st(2)         ##stek: x,eps,n,x_k,x_{k+1}

	## Ispitujemo da li je |x_{k+1} - x_k| < eps
	fxch		          ##stek: x,eps,n,x_{k+1},x_k
	fsubr st(0), st(1)        ##stek: x,eps,n,x_{k+1},x_{k+1}-x_k
	fabs			  ##stek: x,eps,n,x_{k+1},|x_{k+1}-x_k|
	fcomip st(0), st(3)       ##stek: x,eps,n,x_{k+1}

	## Ako jeste, tada izlazimo iz petlje, u suprotnom prelazimo na
	## sledecu iteraciju.
	jb last
	jmp next
last:
	## Skidamo sa steka nepotrebne vrednosti
	fxch st(3)	          ##stek: x_{k+1},eps,n,x
	fcompp	                  ##stek: x_{k+1},eps
	fcomp                     ##stek: x_{k+1} ~ nth_root(x)
	
		
        ## Epilog funkcije.
	pop esi
	pop edi
	pop ebx
        leave
        ret
