.intel_syntax noprefix
	
.text
.global ackermann

##########################################################################
##
## Funkcija:
##
## int ackermann(int m, int n);
##
## odredjuje vrednost Ackermann-ove funkcije A(m,n).
## Argumenti funkcije su:
##
## -- int m -- [ebp + 8] 
## -- int n -- [ebp + 12]
###########################################################################
ackermann:
        ## Prolog funkcije.
	enter 0,0

	
	## Izlaz iz rekurzije (slucaj m == 0) vraca se n + 1
	cmp dword ptr [ebp + 8], 0
	jne first_rec
	mov eax, [ebp + 12]
	inc eax
	jmp done
	
first_rec:
	## Ako je n == 0 ...
	cmp dword ptr [ebp + 12], 0
	jne second_rec

	## tada se poziva A(m - 1, 1)
	mov eax, 1
	push eax
	mov eax, [ebp + 8]
	dec eax
	push eax
	call ackermann
	add esp, 8
	jmp done

	## U suprotnom...
second_rec:
	## poziva se A(m - 1 ,A(m, n - 1))
	mov eax, [ebp + 12]
	dec eax
	push eax
	mov eax, [ebp + 8]
	push eax
	call ackermann
	add esp, 8
	push eax
	mov eax, [ebp + 8]
	dec eax
	push eax
	call ackermann
	add esp, 8
	
done:	
	## Epilog funkcije
	leave
	ret


