#include <stdio.h>
#include <string.h>
#include <ctype.h>

/* Funkcija uzima karakter i prevodi ga u vrednost cifre. Za cifre se
   koriste karakteri '0' - '9' i 'A' - 'Z'  */
unsigned karakter_u_cifru(char c)
{
  return isdigit(c) ? c - '0' : c - 'A' + 10;
}

/* Funkcija uzima vrednost cifre i prevodi je u karakter kojim se ta 
   cifra oznacava */
char cifra_u_karakter(unsigned d)
{
  return d < 10 ? d + '0' : d - 10 + 'A';
}

/* Konvertuje zapis broja x iz osnove b u binarni zapis, koristeci algoritam
   zasnovan na sumi */
void konvertuj_u_binarni(char * x, unsigned b, unsigned * r)
{
  int i;
  unsigned xc;
  *r = 0;
  for(i = 0; x[i] != '\0'; i++)
    {
      xc = karakter_u_cifru(x[i]);
      *r = *r * b + xc;
    }
}

/* Pomocna funkcija obrce string */
void obrni_string(char * s)
{
  unsigned n = strlen(s);
  unsigned i, j;
  for(i = 0, j = n - 1; i < j; i++, j--)
    {
      unsigned t = s[i];
      s[i] = s[j];
      s[j] = t;
    }
}

/* Konvertuje binarni zapis broja x u zapis sa osnovom b, algoritmom
   zasnovanom na deljenju */
void konvertuj_iz_binarnog(unsigned x, unsigned b, char * r)
{
  unsigned i = 0;
  while(x != 0)
    {
      r[i++] = cifra_u_karakter(x % b);
      x = x / b;
    }
  r[i] = '\0';
  obrni_string(r);
}

/* Konvertuje zapis broja iz osnove b1 u b2 (koristeci binarni zapis
   kao posredni) */
void konvertuj_zapis(char * x, unsigned b1, unsigned b2, char * r)
{
  unsigned v;
  konvertuj_u_binarni(x, b1, &v);
  konvertuj_iz_binarnog(v, b2, r);
}

int main()
{
  char x[100];
  char y[100];
  unsigned b1, b2;

  scanf("%d %d", &b1, &b2);
  scanf("%s", x);
  konvertuj_zapis(x, b1, b2, y);
  printf("%s\n", y);

  return 0;
}
