#include <stdio.h>

/* Repna rekurzija (eng. tail recursion) je slucaj kada se telo funkcije 
   zavrsava rekurzivnim pozivom. Ovakva rekurzija se lako moze zameniti 
   iterativnim algoritmom, cime se smanjuje prostorna slozenost algoritma. */

/* Pomocna funkcija koja izracunava n! * result. Koristi repnu 
   rekurziju */
int fact_tail(int n, int result) {
  
  if (n == 0) return result;
  
  return fact_tail(n - 1, n * result);
}

/* Funkcija izracunava n! */
int fact(int n)
{
  return fact_tail(n, 1);
}


/* Test program */
int main()
{
  int n;

  printf("Unesite n (<= 12): ");
  scanf("%d", &n);

  printf("%d! = %d\n", n , fact(n));

  return 0;
}
