#include <stdio.h>
#include <stdlib.h>

/* NAPOMENA: Funkcija moze da poziva samu sebe, neposredno
   ili posredno. Ova pojava se zove rekurzija. Ovakav pristup
   se cesto koristi prilikom resavanja problema koji imaju
   prirodnu rekurzivnu definiciju, tj. kod kojih se problem
   dimenzije n moze jednostavno svesti na problem dimenzije
   n-1 ili neke druge manje dimenzije. Rekurzija je analogna
   matematickoj indukciji.

   Ono sto je potencijalni problem kod rekurzije je to sto se
   u jednom trenutku mogu izvrsavati vise poziva jedne iste 
   funkcije. Npr. ako funkcija f() prilikom svog izvrsavanja
   pozove samu sebe, tada se zapocinje novi poziv iste funkcije.
   Prethodni poziv ceka da se zavrsi tekuci, a zatim nastavlja
   sa radom. Poziv rekurzivne funkcije koji je zapocet, a cije
   izvrsavanje jos nije zavrseno nazivamo aktivni poziv.Svaki 
   poziv funkcije izvrsava se nezavisno od svih ostalih aktivnih
   poziva u tom trenutku, zahvaljujuci cinjenici da svaki od 
   aktivnih poziva ima svoje sopostvene kopije formalnih 
   parametara i lokalnih podataka. Kada se neki od poziva zavrsi,
   njegove kopije nestaju iz memorije, ali kopije ostalih poziva
   i dalje postoje u memoriji. Posledica ovog pristupa je da kada
   rekurzivna funkcija promeni vrednosti svojih lokalnih podataka,
   ove promene ne uticu na ostale aktivne pozive, zato sto oni 
   imaju svoje lokalne kopije istih podataka.
 
   Kreiranje i odrzavanje lokalnih kopija se jednostavno i efikasno
   ostvaruje zahvaljujuci tome sto su parametri funkcije i lokalne
   nestaticke promenljive smestene na sistemskom steku -- u pitanju
   je struktura podataka u kojoj se novi podaci uvek smestaju na vrh
   a prilikom uklanjanja podataka takodje se uklanja podatak sa vrha,
   tj. podatak koji je poslednji dodat (LIFO struktura -- last in, 
   first out). Prilikom pozivanja bilo koje funkcije najpre se na stek
   smeste njeni argumenti (one vrednosti koje su predate prilikom poziva)
   a zatim se na vrh steka smeste i lokalne promenljive. Nakon toga se
   zapocne izvrsavanje tela funkcije. Ako se tom prilikom pozove neka
   druga funkcija (ili ta ista, ako je rekurzija u pitanju) tada se 
   na vrh steka dodaju argumenti ovog poziva, kao i lokalne promenljive
   te funkcije, itd. Kada se funkcijski poziv zavrsi, tada se sa vrha 
   steka skidaju njegove lokalne promenljive, kao i parametri poziva,
   nakon cega na vrhu steka ostaju lokalne promenljive prethodnog poziva
   itd. 

   Lokalni staticki podaci (promenljive deklarisane kao static unutar 
   funkcije) se ne kreiraju na steku, vec u statickoj zoni memorije, 
   i zajednicki su za sve pozive. Zato se promene vrednosti ovih 
   promenljivih u jednom pozivu vide i iz drugih aktivnih poziva iste
   funkcije. Zato treba biti oprezan prilikom koriscenja statickih
   promenljivih u rekurzivnim funkcijama (obicno se to i ne radi).

   Svaka rekurzivna funkcija mora imati izlaz iz rekurzije
   kao i rekurzivni poziv kojim se problem svodi na problem nizeg reda.
   Izlaz iz rekurzije je najcesce jednostavan, ali ne mora uvek da 
   bude tako. */

/* Funkcija rekurzivno racuna faktorijel datog broja */
int fact(int n)
{

   /* Izlaz iz rekurzije */
   if(n == 0)
     return 1;

   /* Rekurzija */
   return n * fact(n - 1);
}

/* Test program */
int main()
{
  int n;

  printf("Unesite n (<= 12): ");
  scanf("%d", &n);

  printf("%d! = %d\n", n , fact(n));

  return 0;
}
