.intel_syntax noprefix
		
.text
.global value

##########################################################################
##
## Funkcija:
##    unsigned value(char * s, unsigned b);
##
##  izracunava vrednost nenegativnog broja zapisanog u stringu s u
##  osnovi b (2 <= b <= 36). Argumenti funkcije su:
##
## -- char * x -- [ebp+8] -- adresa datog stringa.
## -- unsigned b -- [ebp + 12] -- osnova u kojoj je broj zapisan
##
## Funkcija vraca izracunatu vrednost.
##
##########################################################################
value:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

	## Postavljamo smer kretanja kroz stringove.
	cld

	## Registar esi ce sadrzati adresu tekuceg karaktera u stringu.
	## Registar ebx ce sadrzati osnovu.
	mov esi, [ebp + 8]
	mov ebx, [ebp + 12]

	## Anuliramo registar eax
	xor eax, eax

	## Registar ecx ce nam sluziti za akumuliranje sume.
	xor ecx, ecx
	
next_char:
	## Ucitavamo sledeci karakter i proveravamo da li je u pitanju
	## terminirajuca nula.
	lodsb
	cmp al, 0
	je last_char

	## Odredjujemo vrednost procitane cifre. Ako je u pitanju karakter
	## '0' - '9', tada oduzimamo '0'.
	cmp al, '0'
	jb not_0_9
	cmp al, '9'
	ja not_0_9
	
	sub al, '0'
	jmp calculate
	
not_0_9:	
	## Ako karakter nije '0' - '9', tada oduzimamo 'a' i dodajemo 10
	sub al, 'A'
	add al, 10

calculate:	
	mov edi, eax
	mov eax, ecx
	mul ebx
	add eax, edi
	mov ecx, eax
	xor eax, eax

	jmp next_char
last_char:

	## Na kraju upisujemo vrednost broja u eax.
	mov eax, ecx
	
	
done:	
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret


