.intel_syntax noprefix
		
.text
.global product

##########################################################################
##
## Funkcija:
##    void product(int n, double * p, double * q, double * r);
##
## izracunava proizvod polinoma p i q i smesta rezultat u r. Polinomi su
## predstavljeni nizovima svojih koeficienata pocev od slobodnog clana.
## Stepeni ulaznih polinoma su jednaki n. Argumenti funkcije su:
##
## -- int n -- [ebp + 8] -- stepen polinoma p i q
## -- double * p -- [ebp + 12] -- adresa niza p
## -- double * q -- [ebp + 16] -- adresa niza q
## -- double * r -- [ebp + 20] -- adresa niza r
##
##########################################################################
product:
        ## Prolog funkcije.
        enter   0, 0
	push esi
	push edi
	push ebx

	## U registar esi smestamo adresu niza koeficienata p
	mov esi, [ebp + 12]

	## U registar edi smestamo adresu niza koeficienata q
	mov edi, [ebp + 16]

	## U registar ebx smestamo adresu niza koeficienata r
	mov ebx, [ebp + 20]

	## IDEJA: Najpre cemo postaviti sve koeficiente polinoma r na
	## vrednost 0. Zatim cemo u dvostrukoj petlji racunati p[i]*q[j]
	## i to dodavati na r[k], gde je k = i + j.
	
	## U registar edx smestamo indeks k u rezultujucem nizu.
	xor edx, edx

	## U registar ecx smestamo vrednost 2*n
	mov ecx, [ebp + 8]
	shl ecx, 1
next_k:
	cmp edx, ecx
	ja last_k

	fldz				## 0

	## r[k] = 0
	fstp qword ptr [ebx + 8 * edx]  ##
	
	inc edx
	jmp next_k
last_k:	
	
	
	## U registar eax smestamo tekuci indeks i u prvom polinomu
	xor eax, eax
next_i:
	## Dok je i <= n
	cmp eax, [ebp + 8]
	ja last_i

	## U registar ecx smestamo tekuci indeks j u drugom polinomu
	xor ecx, ecx
	
	## U registar edx smestamo indeks k u rezultujucem nizu (inicijalno
	## k = i). U svakoj iteraciji k = i + j.
	mov edx, eax
	
next_j:
	## Dok je j <= n
	cmp ecx, [ebp + 8]
	ja last_j

	fld qword ptr [esi + 8 * eax] ## p[i]
	fld qword ptr [edi + 8 * ecx] ## p[i], q[j]
	fmulp			      ## p[i]*q[j]
	
	fadd qword ptr [ebx + 8 * edx] ## r[k] + p[i]*q[j]

	## Smestamo u memoriju: r[k] = r[k] + p[i]*q[j]
	fstp qword ptr [ebx + 8 * edx] ## 

	inc edx
	inc ecx
	jmp next_j
last_j:	

	inc eax
	jmp next_i
last_i:	

	
	pop ebx
	pop edi
	pop esi
        leave
        ret


