#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deklaracija funkcije */
void product(int n, double * p, double * q, double * r);

int main()
{
  int n;              /* Stepen ulaznih polinoma p i q */
  double *p, *q, *r;  /* Pokazivaci na nizove koeficienata */
  int i;              /* Indeks u petlji */

  /* Ucitavamo n */
  assert(scanf("%d", &n) == 1);
  
  /* Alociramo prostor za nizove */
  assert((p = malloc(sizeof(double) * (n + 1))) != NULL);
  assert((q = malloc(sizeof(double) * (n + 1))) != NULL);
  assert((r = malloc(sizeof(double) * (2 * n + 1))) != NULL);
  
  /* Ucitavamo koeficiente polinoma p */
  for(i = 0; i <= n; i++)
    assert(scanf("%lf", &p[i]) == 1);

  /* Ucitavamo koeficiente polinoma q */
  for(i = 0; i <= n; i++)
    assert(scanf("%lf", &q[i]) == 1);
  
  /* Pozivamo funkciju */
  product(n, p, q, r);

  /* Prikazujemo rezultat */
  for(i = 0; i <= 2*n; i++)
    printf("%g ", r[i]);
  printf("\n");

  /* Oslobadjamo memoriju */
  free(p);
  free(q);
  free(r);
  
  return EXIT_SUCCESS;
}
