.text
.align 2

.global mul

@ Funkcija:
@
@ void mul(int * u, int * v, int * uxv);
@ 
@ izracunava vektorski proizvod u x v. Argumenti funkcije su:
@
@ -- r0 -- int * u
@ -- r1 -- int * v
@ -- r2 -- int * uxv
@
mul:

	@ Prolog funkcije
	stmfd sp!, {fp,lr}
	mov fp, sp

	@ Smestamo na stek vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r6}

	@ U r4 smestamo vrednost x koordinate vektorskog proizvoda
	@ x = yu*zv - yv*zu
	ldr r3, [r0, #4]
	ldr r5, [r1, #8]
	mul r4, r3, r5
	ldr r3, [r0, #8]
	ldr r5, [r1, #4]
	mul r6, r3, r5
	sub r4, r4, r6

	@ Upisujemo x koordinatu vektorskog proizvoda u memoriju
	str r4, [r2]

	@ U r4 smestamo vrednost y koordinate vektorskog proizvoda
	@ y = vx*uz - ux*vz
	ldr r3, [r1]
	ldr r5, [r0, #8]
	mul r4, r3, r5
	ldr r3, [r0]
	ldr r5, [r1, #8]
	mul r6, r3, r5
	sub r4, r4, r6

	@ Upisujemo y koordinatu vektorskog proizvoda u memoriji
	str r4, [r2, #4]


	@ U r4 smestamo vrednost z koordinate vektorskog proizvoda
	@ z = ux*vy - vx*uy
	ldr r3, [r0]
	ldr r5, [r1, #4]
	mul r4, r3, r5
	ldr r3, [r1]
	ldr r5, [r0, #4]
	mul r6, r3, r5
	sub r4, r4, r6

	@ Upisujemo z koordinatu vektorskog proizvoda u memoriji
	str r4, [r2, #8]


	@ Skidamo sa steka vrednosti registra koje smo koristili.
	ldmfd sp!, {r4-r6}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp,pc}
