.intel_syntax noprefix

.text

.global aritmetika

##
## Funkcija:
##
## int aritmetika(int a, char op, int b)
##
## izracunava jednu od vrednosti a + b, a - b, a * b, a / b ili a % b
## u zavisnosti od parametra op koji moze biti karakter '+', '-'
## '*', '/' ili '%'. Parametri funkcije:
##
## -- int a -- [ebp + 8]
## -- char op -- [ebp + 12]	
## -- int b -- [ebp + 16]
##
aritmetika:
	enter 0,0
	push ebx

	## NAPOMENA: S obzirom da sve funkcije koriste iste registre procesora
	## postoji opasnost da funkcija koja se trenutno izvrsava "pokvari"
	## vrednost nekog registra koju je postavila pozivajuca funkcija
	## a koju namerava da koristi i nakon zavrsetka tekuce funkcije.
	## Zbog toga se moraju postovati izvesne konvencije koje se ticu
	## registara: postoje registri koji "pripadaju" pozivajucoj funkciji
	## i registri koji "pripadaju" pozvanoj funkciji. Pozivajucoj
	## funkciji pripadaju registri ebx, esi i edi. Pozivajuca funkcija
	## u njima sme ostaviti bilo koju vrednost koja je za nju znacajna
	## bez bojazni da ce neka od pozvanih funkcija promeniti vrednost
	## tih registara. To ne znaci da pozvana funkcija ne sme da ih
	## koristi -- ona to moze, ali u tom slucaju mora sacuvati njihove
	## vrednosti na steku (instrukcijom push). U slucaju ove funkcije
	## koristi se registar ebx, pa se zato njegova vrednost koja je
	## nasledjena iz pozivajuce funkcije na pocetku stavlja na stek,
	## a na kraju se sa steka vraca u ebx. Ukoliko bi vise registara
	## bilo cuvano na pocetku funkcije (npr ebx i esi), tada bi se
	## na kraju funkcije njihove vrednosti vracale u registre u
	## obrnutom poretku. Registri eax, ecx, edx pripadaju pozvanoj
	## funkciji. To znaci da ona sme da ih koristi a da pritom ne mora
	## da sacuva njihove vrednosti za pozivajucu funkciju. Sa druge
	## strane, pozivajuca funkcija ne sme racunati na ove registre i
	## bilo sta sto joj je bitno mora izmestiti iz ovih registara
	## na neke druge lokacije pre poziva bilo koje druge funkcije.

	## NAPOMENA: Posto se na stek nikada ne stavljaju vrednosti manje
	## od 4 bajta (zbog efikasnosti pristupa memoriji), ako funkcija
	## ima parametar tipa char ili short, tada se prilikom poziva
	## funkcije po konvenciji njihove vrednosti uvek promovisu
	## u int. Tako je i u slucaju nase funkcije -- poslednji parametar
	## op se zapravo ponasa kao int (zauzima 4 bajta na steku) iako
	## je deklarisan kao char.
	
	## Ucitavamo u registar ebx vrednost a, u registar ecx vrednost b,
	## a u eax ASCII kod karaktera koji predstavlja operator.
	mov eax, [ebp + 12]
	mov ebx, [ebp + 8]
	mov ecx, [ebp + 16]

	
	## Ispitujemo sta je operator. 
	cmp eax, '+'
	je sabiranje
	cmp eax, '-'
	je oduzimanje
	cmp eax, '*'
	je mnozenje
	cmp eax, '/'
	je deljenje
	cmp eax, '%'
	je ostatak
	
sabiranje:
	## Sabiramo a i b i zbir smestamo u eax.
	add ebx, ecx
	mov eax, ebx
	jmp kraj

	## NAPOMENA: Instrukcija sub oduzima drugi od prvog operanda i
	## dobijenu razliku smesta u prvi operand. Za razliku od nje,
	## instrukcija cmp samo vrsi oduzimanje, ali ne smesta razliku
	## u prvi operand (samo azurira flag-ove, kao sto je ranije opisano).
	
oduzimanje:
	## Oduzimamo a i b i razliku smestamo u eax
	sub ebx, ecx
	mov eax, ebx
	jmp kraj

	## NAPOMENA: Operacije mnozenja i deljenja su malo komplikovanije.
	## Prvo, treba imati u vidu da kada mnozimo dva 32-bitna broja,
	## dobijamo 64-bitni proizvod. To znaci da ce procesor morati da
	## koristi dva registra za smestanje rezultata mnozenja. Instrukcija
	## mul podrazumeva da se jedan njen operand nalazi u registru eax
	## (ovo je implicitni operand, i ne navodi se), dok se drugi operand
	## navodi i moze biti registar ili memorijski operand. U slucaju
	## da je memorijski operand, mora se navesti njegova sirina (dword
	## ptr). Nizih 32 bita proizvoda se smesta u eax, dok se visih
	## 32-bita smesta u edx. Ovo treba imati u vidu, jer ne bi smeli
	## da ostavimo nesto bitno u edx-u ako vrsimo mnozenje (bice
	## ponisteno). Takodje, setimo se da su algoritmi za mnozenje
	## neoznacenih brojeva i oznacenih brojeva razliciti -- zbog toga
	## postoje dve razlicite instrukcije -- mul za neoznacene i imul
	## za oznacene brojeve. Ako postoji mogucnost da vrednosti koje
	## se mnoze budu negativne, tada se mora koristiti instrukcija imul,
	## u suprotnom ce ih procesor tumaciti kao velike pozitivne neoznacene
	## brojeve. Slicna je situacija i sa deljenjem (div i idiv). Sa druge
	## strane, postoji samo jedna instrukcija za sabiranje i oduzimanje
	## (add i sub), zato sto su algoritmi za sabiranje i oduzimanje isti
	## i za oznacene i za neoznacene brojeve.
	
mnozenje:
	## Mnozimo a i b. Proizvod ostaje u eax.
	mov eax, ebx
	imul ecx
	jmp kraj

	## NAPOMENA: Instrukcija deljenja (div i idiv) je inverzna
	## odgovarajucoj instrukciji mnozenja (mul, odnosno imul). Ona
	## deli 64-bitni deljenik sa 32-bitnim deliocem i dobija
	## 32-bitni celobrojni kolicnik i 32-bitni ostatak. Deljenik se
	## pre instrukcije smesta u registre edx (visih 32 bita) i eax
	## (nizih 32 bita). S obzirom da mi u vecini slucajeva imamo
	## deljenik koji je takodje 32-bitni, treba ga prosiriti u 64-bitni
	## zapis. U slucaju neoznacenih brojeva to se radi tako sto se
	## prosto u eax upise vrednost deljenika a u edx se upise 0. U slucaju
	## oznacenih brojeva, vrsi se oznaceno prosirivanje. U tu svrhu se
	## najpre u eax upise vrednost deljenika, a onda se pozove instrukcija
	## cdq, koja vrsi oznaceno prosirivanje, tj. u edx upisuje ili 0 (ako
	## je eax pozitivan) ili sve jedinice (ako je eax negativan). Delilac
	## se navodi kao operand instrukcije (registar ili memorijski
	## operand). Nakon deljenja, celobrojni kolicnik se nalazi u eax,
	## a ostatak u edx.
	
deljenje:
	## Delimo a i b. Kolicnik ostaje u eax.
	mov eax, ebx
	cdq
	idiv ecx
	jmp kraj
	
ostatak:
	## Delimo a i b. Ostatak se prebacuje iz edx u eax.
	mov eax, ebx
	cdq
	idiv ecx
	mov eax, edx
	
kraj:
	## Skida se sa steka originalna vrednost registra
	## ebx, nasledjena iz pozivajuce funkcije.
	pop ebx
	leave
	ret
	
