.text
.align 2


.global int_to_string

@ Funkcija:
@
@ void int_to_string(unsigned x, unsigned b, char * s);
@
@ odredjuje zapis nenegativnog broja x u datoj osnovi b i formira 
@ string s koji sadrzi dati zapis. Pretpostavlja se da je osnova 
@ manja ili jednaka 36, a za cifre se koriste karakteri 0-9 i A-Z.
@ Argumenti funkcije su:
@
@ -- r0 -- unsigned x -- dati broj
@ -- r1 -- unsigned b -- osnova
@ -- r2 -- char * s -- adresa pocetka niza u koji treba upisati string
@
int_to_string:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo vrednosti registara koje cemo koristiti
	stmfd sp!, {r4-r7}

	@ U registar r4 smestamo dati broj x, u registar r5 osnovu b
	@ a u registar r7 adresu pocetka stringa.
	mov r4, r0
	mov r5, r1
	mov r7, r2

	@ Registar r6 ce sadrzati pokazivac na poziciju u koju treba
	@ upisati sledeci karakter.
	mov r6, r2

	@ U petlji delimo broj sa osnovom b i izdvajamo cifru po cifru
next_digit:
	mov r0, r4
	mov r1, r5
	bl __umodsi3

	@ Cifra se nalazi u registru r0. Ako je cifra manja od 10, tada
	@ koristimo karaktere '0' - '9'
	cmp r0, #10
	addlo r0, r0, #'0'
	strlob r0, [r6], #1
	
	@ Ako je cifra >= 10, koristimo karaktere 'A' - 'Z'
	subhs r0, r0, #10
	addhs r0, r0, #'A'
	strhsb r0, [r6], #1

	@ Odredjujemo kolicnik x / b, i smestamo ga u r4 (x).
	mov r0, r4
	mov r1, r5
	bl __udivsi3
	mov r4, r0

	@ Ako je kolicnik 0, tada smo procitali sve cifre
	cmp r4, #0
	beq last_digit

	@ U suprotnom prelazimo na sledecu cifru
	b next_digit
last_digit:

	@ Terminiramo string nulom
	mov r0, #0
	strb r0, [r6]

	@ S obzirom da su cifre u obrnutom poretku, okrecemo string
	@ r7 sadrzi adresu pocetka stringa, a r6 adresu terminirajuce
	@ nule. Zato r6 umanjujemo za jedan.
	sub r6, r6, #1
	
	@ U svakoj iteraciji zamenjujemo mesta paru karaktera sa pocetka
	@ i kraja stringa, a zatim pomeramo pokazivace ka sredini 
	@ stringa
next_pair:
	cmp r7, r6
	bhs last_pair

	ldrb r0, [r7]
	ldrb r1, [r6]
	strb r0, [r6], #-1
	strb r1, [r7], #1

	b next_pair
last_pair:



	@ Skidamo sa steka vrednosti registara koje smo koristili
	ldmfd sp!, {r4-r7}

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
