.intel_syntax noprefix

.data
	
mask: .int 0xffffffff, 0x7fffffff, 0xffffffff, 0x7fffffff
	
.text 
.global diff
#############################################################################
##
## Funkcija:
##
## void diff(double * x, double * y, int n, double * r);
##
## racuna sumu sum_{0..n-1}|x[i] - y[i]|, koristeci paralelne SSE2
## instrukcije. Argumenti funkcije su:
## 
## -- double * x --  [ebp+8]  -- adresa prvog niza
## -- double * y --  [ebp+12] -- adresa drugog niza
## -- int n      --  [ebp+16] -- duzina nizova
## -- double * r --  [ebp+20] -- adresa na koju treba smestiti rezultat
##
############################################################################ 
diff:
	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	
        ## Proverava se da li procesor podrzava SSE2 instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x4000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara (i registara koprocesora).
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## U registar ecx smestamo duzinu nizova n
	mov ecx, [ebp + 16]

	## U registar esi smestamo adresu prvog, a u edi drugog niza
	mov esi, [ebp + 8]
	mov edi, [ebp + 12]

	## U registru xmm2 cemo cuvati parcijalne sume
	xorpd xmm2, xmm2

	## U registru xmm7 cemo cuvati masku za racunanje apsolutne
	## vrednosti.
	movupd xmm7, mask

	
next_two:
	## Ako je ostalo bar jos dva sabirka
	cmp ecx, 2
	jb check_one

	## Ucitavamo sledeca dva para brojeva
	movupd xmm0, [esi]
	add esi, 16
	movupd xmm1, [edi]
	add edi, 16

	## Oduzimamo ih i racunamo apsolutnu vrednost
	subpd xmm0, xmm1
	andpd xmm0, xmm7

	## Dodajemo na parcijalne sume
	addpd xmm2, xmm0

	## Umanjujemo brojac i prelazimo na sledecu iteraciju
	sub ecx, 2
	jmp next_two

check_one:	
	jecxz last

	## Ako je preostao jos jedan element, tada ga dodajemo
	## na nizu sumu.
	movsd xmm0, [esi]
	movsd xmm1, [edi]
	subsd xmm0, xmm1
	andpd xmm0, xmm7
	addsd xmm2, xmm0
last:
	
	## Sabiramo dve parcijalne sume
	movhlps xmm0, xmm2
	addsd xmm2, xmm0

	## Upisujemo rezultat u za to predvidjenu lokaciju
	mov esi, [ebp + 20]
	movsd [esi], xmm2
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
	## registre.
        fxrstor [esp]
        mov     esp, edx

	## Epilog funkcije.
	pop edi
	pop esi
	leave
	ret

not_supported:
	## Ako SSE2 instrukcije nisu podrzane, prekidamo program exit(1)
	## pozivom. 
	mov eax, 1
	mov ebx, 1
	int 0x80
	