.intel_syntax noprefix

.text
.global quick_sort

##########################################
## void quick_sort(int a[],int l,int r) ##
## 
## [ebp+8] -- int * a
## [ebp+12] -- int l
## [ebp+16] -- int r
##########################################
quick_sort:

## Prolog funkcije
enter 0,0
push esi
push edi
push ebx

## U registar esi smestamo adresu pocetka niza,
## u registar ebx smestamo levu, a u ecx desnu
## granicu dela niza koji se sortira.

mov esi, [ebp+8]
mov ebx, [ebp+12]
mov ecx, [ebp+16]	

## U registar edi smestamo krajnji desni element dela
## niza koji se sortira (pivot). Koristimo indeksno
## adresiranje.
mov edi, [esi+ecx*4]

## Izlaz iz rekurzije: ako nije l < r, prekidamo
## tekuci rekurzivni poziv, zato sto je niz prazan
## ili jednoclan.
cmp ebx,ecx
jge end_quick_sort


## Glavna petlja. Ponavlja se sve dok je levi
## index manji od desnog. Petlja je evivalentna
## sa while(l < r) { ... }
main_loop:	
cmp ebx,ecx	
jge end_main_loop	

## Ovom petljom trazimo najlevlji element
## veci od pivota. Ekvivalentno sa 
## while(l < r && a[l]<=pivot) l++;
left_loop:
cmp ebx,ecx
jge end_left_loop
cmp [esi+ebx*4], edi
jg end_left_loop	
inc ebx	
jmp left_loop
end_left_loop:

## Ovom petljom trazimo najdesniji element
## manji od pivota. Ekvivalentno sa
## while(l < r && array[r]>=pivot) r--;
right_loop:	
cmp ebx,ecx	
jge end_right_loop	
cmp [esi+ecx*4], edi	
jl end_right_loop
dec ecx
jmp right_loop
end_right_loop:

# Ovo je obican swap algoritam elemenata koji su
# indeksirani levim (ebx) i desnim (ecx) indeksom
# Kao privremene lokacije podataka koristimo
# registre eax i edx.
mov eax,[esi+ecx*4]
mov edx,[esi+ebx*4]
mov [esi+ebx*4],eax
mov [esi+ecx*4],edx

jmp main_loop
end_main_loop:

## U ovom trenutku vazi ecx = ebx = f, gde je
## f pozicija na koju treba smestiti pivot.

## Swap-ovanje pivota i elementa na utvrdjenoj
## poziciji. ecx nakon toga sadrzi indeks poslednjeg
## elementa (r)
mov eax,[esi+ecx*4]	
mov [esi+ecx*4],edi	
mov ecx,[ebp+16]	
mov [esi+ecx*4],eax	

## Sortiramo rekurzivno levu i desnu particiju. Odmah
## na stek stavljamo argumente i jednog i drugog 
## rekurzivnog poziva. 

## Postavljamo na stek argumente rekurzivnog poziva
## quick_sort(array,f+1,r) gde je f pozicija pivota.
## U registru ecx nam se nalazi r, dok se u registru
## ebx nalazi f. Registar esi jos od ranije sadrzi
## adresu pocetka niza. 
push ecx
inc ebx
push ebx
push esi

## Postavljamo na stek argumente rekurzivnog poziva
## quick_sort(array,l,f-1). U registru ebx nam se trenutno
## nalazi f+1, dok se indeks l nalazi u memoriji
## na poziciji [ebp+12]. esi ponovo sadrzi adresu
## pocetka niza.
sub ebx,2
push ebx
push dword ptr [ebp+12]
push esi

## Pozivamo qsort za donju, a zatim i za gornju particiju.
call quick_sort	
add esp,12
call quick_sort
add esp,12


end_quick_sort:


## epilog f-je
pop ebx
pop edi
pop esi
leave
ret
