.intel_syntax noprefix

.data
## Podatak koji predstavlja konstantu 2
two: .int 2

.text
.global bin_search

################################################
## int bin_search(int a[], int n, int x)
##
## [ebp+8] -- int * a
## [ebp+12] -- int n
## [ebp+16] -- int x
################################################
bin_search:

## prolog f-je
enter 0,0
push esi
push edi
push ebx



## Postavljamo adresu niza u esi. Koristicemo
## indeksno adresiranje.
mov esi,[ebp+8]

## Postavljamo ebx na 0. Ovaj registar ce nam biti
## levi indeks binarne pretrage.
xor ebx,ebx

## Postavljamo ecx na n - 1. Ovaj registar ce nam biti 
## desni indeks binarne pretrage.
mov ecx,[ebp+12]
dec ecx

## Postavljamo edi na vrednost trazenog elementa.
mov edi,[ebp+16]


## Petlja oblika while(l<=r) { ... }
## uslov izlaska je da je levi (ebx) 
## veci od desnog (ecx) indeksa. 
main_loop:
cmp ebx,ecx	
jg not_found

## Odredjujemo aritmeticku sredinu (l+r)/2.
mov eax,ebx	
add eax,ecx	
cdq
idiv dword ptr two

## Poredimo trazeni element, koji se nalazi 
## u edi sa elementom na poziciji (l+r)/2.
## Ako su jednaki, zavrsavamo pretragu.
cmp edi, [esi+eax*4]
je end_search
jl lower

## Pretraga gornje polovine niza, u slucaju da
## je trazeni element veci od sredisnjeg. Pomeramo
## levi indeks (ebx) na (l+r)/2 + 1.
greater:
mov ebx,eax
inc ebx	
jmp main_loop	

## Pretraga donje polovine niza, u slucaju da
## je trazeni element manji od sredisnjeg. Pomeramo
## desni indeks (ecx) na (l+r)/2 - 1.
lower:
mov ecx,eax
dec ecx
jmp main_loop	

end_main_loop:

## U slucaju neuspeha, vracamo -1
not_found:
mov eax,-1
	
end_search:

## epilog f-je
pop ebx
pop edi
pop esi
leave
ret
