.intel_syntax noprefix

.text
.global fractions

##########################################################################
##
## Funkcija:
##
## void fractions(int * f, int n, int * r);
##
## odredjuje najveci u nizu razlomka. Razlomci su dati u nizu na koji pokazuje
## f (najpre brojilac i imenilac prvog razlomka, zatim drugog, i tako dalje).
## Rezultat treba smestiti u niz na koji pokazuje r.
## Argumenti funkcije su:
##
## -- int * f -- [ebp+8]  -- adresa pocetka niza razlomaka
## -- int n   -- [ebp+12]  -- broj razlomaka u nizu 
## -- int * r -- [ebp+16]  -- adresa pocetka niza u koji treba upisati
## brojilac i imenilac rezultata.
##
###########################################################################
fractions:
        ## Prolog funkcije.
        enter   0, 0
	push esi
	push edi
	push ebx

	## U registar esi smestamo adresu niza razlomaka.
	mov esi, [ebp + 8]

	## Registar edi ce sadrzati brojilac, a registar ebx imenilac
	## trenutno najveceg razlomka (inicijalno, to je prvi razlomak).
	mov edi, [esi]
	mov ebx, [esi + 4]

	## Pomeramo esi na sledeci razlomak.
	add esi, 8
	
	## Registar ecx cemo koristiti kao brojac preostalih razlomaka.
	## Inicijalno, to je n - 1.
	mov ecx, [ebp + 12]
	dec ecx

	## Ako nema vise razlomaka, zavrsavamo.
	jecxz last
next:
	## Cuvamo ecx na steku, jer cemo ga koristiti u petlji.
	push ecx
	
	## Ucitavamo u eax brojilac, a u ecx imenilac sledeceg razlomka.
	mov eax, [esi]
	mov ecx, [esi + 4]

	## Da bi za razlomke vazilo a/b > c/d, mora biti ad > cb. Zato
	## najpre mnozimo ad i proizvod smestamo u ecx (a brojilac novog
	## razlomka prebacujemo u eax za sledece mnozenje)
	mul ebx
	xchg eax, ecx

	## Sada racunamo cb.
	mul edi

	## Poredimo, i ako je ad > cb, tada azuriramo maksimum.
	cmp ecx, eax
	jg new_max
	jmp continue
	
new_max:
	mov edi, [esi]
	mov ebx, [esi + 4]

continue:
	## Prelazimo na sledeci razlomak.
	add esi, 8
	pop ecx
	loop next
last:	
	## Smestamo rezultat u za to predvidjene lokacije.
	mov esi, [ebp + 16]
	mov [esi], edi
	mov [esi + 4], ebx
	
        ## Epilog funkcije.
	pop ebx
	pop edi
	pop esi
        leave
        ret
