`timescale 1ns/1ns
`include "rsl.v"

module rsl_test;
   reg s, r, e;
   wire q, qp;
   
   rsl _rsl(s, r, e, q, qp);
   
   initial
     begin
	$monitor($time, ": e: %b, s: %b, r: %b, q: %b, qp: %b", e, s, r, q, qp);

	// Kada je e == 0, kolo ne reaguje na promene r i s ulaza
	e = 0; 
        s = 0; r = 0; 
	#10 s = 1;
	#10 s = 0;
	#10 r = 1;
	#10 r = 0;

	// Kada je e == 1, tada kolo reaguje na promene ulaza r i s
	#10 e = 1;	
	#10 s = 1;
	#10 s = 0;
	#10 r = 1;
	#10 r = 0;

	// Nedozvoljena kombinacija na ulazu (na izlazu dobijamo q = 0, qp = 0)
	#10  s = 1; r = 1;

	// Nakon sto se vratimo na s = 0, r = 0, rezultat ce zavisiti od redosleda
	// obaranja signala s i r na 0 (u Verilogu je to uvek u onom poretku u kom
	// je navedeno u begin-end naredbi, ali u praksi je to nedeterministicko
	// ponasanje)
	#10  
	  s = 0; r = 0;

     end
   

endmodule
