`timescale 1ns/1ns
`include "rsff.v"

module rsff_test;
   reg s, r, clk;
   wire q, qp;
   
   rsff _rsff(s, r, clk, q, qp);

   
   
   initial
     begin
	$monitor($time, ": clk: %b, s: %b, r: %b, q: %b, qp: %b", clk, s, r, q, qp);
	$dumpfile("rsff.vcd");
	$dumpvars(1, rsff_test);
	
	
	// Kolo reaguje samo prilikom promene vrednosti e ulaza sa 0 na 1 (vrednosti
	// r i s ulaza u tom trenutku odredjuju sta ce se desiti na izlazu).
	clk = 0; s = 0; r = 0;
	#10 s = 1;      
	#10 clk = 1;	
	#10 s = 0;       
	#10 r = 1;
	#10 r = 0;
	#10 clk = 0;	
	#10 s = 1;
	#10 s = 0;
	#10 r = 1;
	#10 clk = 1;	
	#10 r = 0;
	#10;	

     end
   
endmodule // rsff_test
