// 8-bitni multiplekser 4-1 (u zavisnosti od vrednosti 2-bitnog selekcionog
// ulaza s jedan od 4 osmobitna ulaza (a,b,c,d) se prosledjuje na izlaz (out)
// U pitanju je standardna implementacija sa and i or kolima.
module mux41(a, b, c, d, s, out);
   input [7:0] a, b, c, d;
   input [1:0] s;
   output [7:0] out;

   wire [7:0] 	ap, bp, cp, dp;
   wire [1:0]	s_neg;
     
   not _not_s[1:0] (s_neg, s);
   
   and _and_a[7:0] (ap, a, s_neg[0], s_neg[1]);
   and _and_b[7:0] (bp, b, s[0], s_neg[1]); 
   and _and_c[7:0] (cp, c, s_neg[0], s[1]);
   and _and_d[7:0] (dp, d, s[0], s[1]);

   or _or[7:0] (out, ap, bp, cp, dp);
 
endmodule // mux41
