/* Skup registara opste namene (16 32-bitnih registara). Kolo moze ucitavati 
   vrednosti sa obe magistrale, kao i slati vrednosti na obe magistrale */
module regs(clk, bus_a, bus_b, bus_a_sel, bus_b_sel, e_a_in, e_b_in, e_a_out, e_b_out);
   input clk;
   inout[31:0] bus_a, bus_b;
   input [3:0] bus_a_sel, bus_b_sel;
   input       e_a_in, e_b_in, e_a_out, e_b_out;

   reg [31:0]  r[0:15];
   integer     i;
   
   
   // Izlaz na magistrale je kontrolisan pomocu e_a_out i e_b_out signala
   // Kada su ovi signali na nuli, odgovarajuce magistrale ne primaju
   // signal iz ovog kola
   assign bus_a = e_a_out ? r[bus_a_sel] : 32'hzzzzzzzz; 
   assign bus_b = e_b_out ? r[bus_b_sel] : 32'hzzzzzzzz;

   // Initial proces kojim se inicijalizuju vrednosti registara na 0.
   // Brojacka promenljiva for petlje je deklarisana kao integer.  U
   // pitanju je 32-bitni oznaceni celobrojni registarski tip (isto
   // kao da smo napisali reg signed [31:0] i).  
   initial
     begin
	for(i = 0; i < 16; i = i + 1)
	  r[i] <= 0;	
     end
   
   // Proces za upis vrednosti sa magistrala A i B
   // (radi samo kada je e_a_in odnosno e_b_in ukljucen)
   always @(negedge clk)
     begin
	if(e_a_in)
	  begin
	     r[bus_a_sel] <= bus_a;
	     $display($time, ": r%d = %d", bus_a_sel, bus_a);	  
	  end
	if(e_b_in)
	  begin
	     r[bus_b_sel] <= bus_b;
	     $display($time, ": r%d = %d", bus_b_sel, bus_b);	  	  
	  end	
     end

endmodule // regs

