/* Kolo predstavlja PC registar koji cuva adresu tekuce instrukcije. 
   Moguce je vrednost ovog registra poslati na bilo koju od magistrala.
   Prilikom ucitavanja sa A magistrale vrednost se upisuje u registar
   kao apsolutna vrednost. Prilikom ucitavanja sa B magistrale vrsi
   se dodavanje vrednosti bus_b[31:8] * 4 na trenutnu vrednost registra 
   (ovo se koristi kod relativnog adresiranja). Takodje, postoji i 
   e_inc signal koji uvecava vrednost registra za 4 (prelazak na 
   sledecu instrukciju) */
module pc(clk, bus_a, bus_b, e_a_in, e_b_in, e_a_out, e_b_out, e_inc);
   input clk;
   inout[31:0] bus_a, bus_b;
   input       e_a_in, e_b_in;
   input       e_a_out, e_b_out;
   input       e_inc;   
   
   reg [31:0]  r;

   assign bus_a = e_a_out ? r : 32'hzzzzzzzz;
   assign bus_b = e_b_out ? r : 32'hzzzzzzzz;

   initial
     r <= 0;


   
   always @(negedge clk)
     if(e_a_in)
       r <= bus_a;
     else if(e_b_in)
       r <= r + (($signed(bus_b) >>> 6) & $signed(32'hfffffffc));
     else if(e_inc)
       r <= r + 32'd4;
   
   always @(r)
     $display($time, ": pc = %h", r);
   
endmodule // pc
