/* Model jednostavnog arbitra magistrale. U pitanju je sekvencijalno
   kolo koje reaguje na negativnu ivicu casovnika. Zahtev za pristup
   magistrali se postavlja na pozitivnoj ivici casovnika. Ukoliko
   transakcija nije u toku (bus_in_use == 0), tada se na sledecoj
   negativnoj ivici aktivira bus_grant signal. Ovaj signal ce biti
   aktivan jedan ciklus, nakon cega se vraca na nulu (tada je
   transakcija vec zapocela). Od master uredjaja se ocekuje da nakon
   toga iskljuci bus_request signal, nakon cega arbitar iskljucuje
   bus_grant signal. */
module arbiter(clk, bus_request, bus_in_use, bus_grant); 
   input clk, bus_request, bus_in_use; 
   output reg bus_grant;

   initial
     bus_grant <= 0;
   
   
   always @(negedge clk)
     if(bus_request && !bus_in_use && !bus_grant)
       bus_grant <= 1;
     else
       bus_grant <= 0;

   
endmodule // arbiter
