/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#include <iostream>
#include "retkaMatrica.hh"

using namespace std;

namespace jwork {

retkaMatrica::retkaMatrica( unsigned s, unsigned v ) : matrica(s,v) {
}

retkaMatrica::retkaMatrica(const retkaMatrica &A) : matrica(A.sirina(),A.visina()) {
  data=A.data;
}

retkaMatrica & retkaMatrica::operator=(const retkaMatrica &A) {
  if (this != &A) {
    promeni_dimenzije(A.sirina(),A.visina());

    map <pos,T>::const_iterator iter;
    data.erase(data.begin(),data.end());

    data=A.data;
  }
  return *this;
}

retkaMatrica::~retkaMatrica() {
}

bool retkaMatrica::postoji( pos & p, cpositer & iter ) const {
  iter = data.find(p);
  if (iter==data.end())
    return false;
  return true;    
}

void retkaMatrica::obrisi( pos & p ) {
  positer iter(data.find(p));
  iter = data.find(p);
  if (iter!=data.end())
    data.erase(iter);
}

void retkaMatrica::sviElementi() const {
  cpositer iter=data.begin(),
           iend=data.end();
int i(0);
  while ( iter != iend ) {
    pos p(iter->first);
    cout << "(" << p.first << "," << p.second << ") = " << iter->second << "\t";
    iter++;
    i++;
    if (i==5) { 
      cout << endl;
      i=0;
    }
  }
}

T retkaMatrica::get(unsigned x, unsigned y) const {

  cpositer iter;
  pos p(x,y);
  T r(0);

  broji_get();	// ovde treba brojati iteriranje, potrebno je izracunati prosek log(n)... itd. itd.

  if (postoji(p, iter));
    r = iter->second;

  return r;

}

void retkaMatrica::set(unsigned x, unsigned y, T broj) {

  broji_set();

  if (fabs(broj)>NULA)
    data[pos(x,y)]=broj;
  else {
    pos p(x,y);
    obrisi(p);
  }
}

unsigned retkaMatrica::size() const {
  return data.size()*(sizeof(T)+2*sizeof(int))+sizeof(retkaMatrica);
}

void retkaMatrica::nule() {
  data.erase(data.begin(),data.end());
}

void retkaMatrica::postaviNovuMatricu(unsigned sirina, unsigned visina) {
  data.erase(data.begin(),data.end());
  promeni_dimenzije(sirina,visina);
}



} // namespace

