#include "matrice.h"
#include "matmulPthreads.hh"

using namespace std;
using namespace jwork;

int main(int argc, char **argv) {
  try {
    unsigned DIM(10);
    unsigned thr(2);
    
    if (argc>=2) DIM=atoi(argv[1]);
    if (argc==3) thr=atoi(argv[2]);
    
    if (DIM==0) DIM=10;
    if (thr==0) thr=2;

    gustaMatrica A(3*DIM,DIM);    // konstrukcija kvadratne matrice 3*DIM x DIM
    gustaMatrica B(2*DIM,3*DIM);
    gustaMatrica C;
    
    A.randomN(10);                    
    B.randomN(10);
    
    cout << "BROJ NITI          : " << thr << endl;
    cout << "Dimenzija problema : (" << A.sirina() << 'x' << A.visina() << ") x (" << B.sirina() << 'x' << B.visina() << ")" << endl;
    resetujBrojace();
    matmulPthreads(A,B,C,thr);
    ispisiStanjeBrojaca(cout);
    cout << "Dimenzija matrice C: (" << C.sirina() << 'x' << C.visina() << ')' << endl;
    

  } catch( int err ) {
    cerr << "ERROR!! " << err << endl;
  }
}
