#include "matrice.h"
#include "jacobiPthreads.hh"

using namespace std;
using namespace jwork;

int main(int argc, char **argv) {
  try {
    unsigned DIM(10);
    unsigned thr(2);
    
    if (argc>=2) DIM=atoi(argv[1]);
    if (argc==3) thr=atoi(argv[2]);
    
    if (DIM==0) DIM=10;
    if (thr==0) thr=2;

    gustaMatrica A(DIM,DIM);    // konstrukcija kvadratne matrice DIM x DIM
    gustaMatrica b(1,DIM);      // vektor b
    gustaMatrica x(1,DIM);      // vektor u kome se smesta rezultat
    unsigned brojIteracija;
    
    A.randomN(10);                    
    b.randomN(20);
    diagDominant(A);
    
    resetujBrojace();
    cout << "BROJ NITI          : " << thr << endl;
    cout << "Dimenzija problema : " << A.visina() << endl;
    brojIteracija = jacobiPthreads(A,b,x,thr);
    ispisiStanjeBrojaca(cout);
    
    cout << endl << "Jakobijeva metoda je iskonvergirala u " << brojIteracija << " iteracija za tacnost " << EPSILON << endl;

  } catch( int err ) {
    cerr << "ERROR!! " << err << endl;
  }
}
