#include "matrice.h"

using namespace std;
using namespace jwork;

int main(int argc, char **argv) {
  try {

    unsigned DIM(10);
    
    if (argc==2)
      DIM=atoi(argv[1]);
    
    if (DIM==0)
      DIM=10;

    gustaMatrica A(DIM,DIM);    // konstrukcija kvadratne matrice DIM x DIM
    gustaMatrica b(1,DIM);      // vektor b
    gustaMatrica x(1,DIM);      // vektor u kome se smesta rezultat
    unsigned brojIteracija;
    
    A.randomN(10);                    
    b.randomN(20);
    diagDominant(A);
    
//    A.ispisi(cout,&b);          // ispis matrice A za kojom sledi matrica B

    brojIteracija = SLJ_JacobiIter(A,b,x,false);
    cout << endl << "Jakobijeva metoda je iskonvergirala u " << brojIteracija << " iteracija za tacnost " << EPSILON << endl;

    brojIteracija = SLJ_JacobiIter(A,b,x,true);
    cout << endl << "Gauss Saidel-ova metoda je iskonvergirala u " << brojIteracija << " iteracija za tacnost " << EPSILON << endl;

  } catch( int err ) {
    cerr << "ERROR!! " << err << endl;
  }
}
