#include <iostream>
#include <mpi.h>

using namespace std;

#define DIM 4

void master(unsigned brojProcesa) {
  double zaSlanje[DIM][DIM] = {
    { 1, 2, 3, 4 },
    { 5, 6, 7, 8 },
    { 4, 3, 2 ,1 },
    { 5, 3, 1 ,9 } };
    
  double primam[DIM];

  MPI::COMM_WORLD.Scatter(zaSlanje, DIM, MPI::DOUBLE, primam, DIM, MPI::DOUBLE, 0);
  
  cout << "ID=" << 0 << '\t';
  for (unsigned i=0;i<DIM;i++) 
    cout << primam[i] << ' ';
  cout << endl;
}

void slave(unsigned processID) {
  double primam[DIM];

  MPI::COMM_WORLD.Scatter(0,0, MPI::DOUBLE , primam, DIM, MPI::DOUBLE, 0);
  
  cout << "ID=" << processID << '\t';
  for (unsigned i=0;i<DIM;i++) 
    cout << primam[i] << ' ';
  cout << endl;
}

int main(int argc, char **argv) {

  MPI::Init(argc, argv);
  int mojID       = MPI::COMM_WORLD.Get_rank();
  int brojProcesa = MPI::COMM_WORLD.Get_size();
  
  if (brojProcesa==DIM) {  
    if (mojID==0)
      master(brojProcesa);
    else
      slave(mojID);
      
  } else {
    cerr << "program je predvidjen da radi samo na " << DIM << " procesa" << endl;
  }
  
  MPI::Finalize();
}
