#include <iostream>
#include <mpi.h>

using namespace std;

#define DIM 4

int main(int argc, char **argv) {

  double zaSlanje[DIM][DIM] = {
    { 1, 2, 3, 4 },
    { 5, 6, 7, 8 },
    { 4, 3, 2 ,1 },
    { 5, 3, 1 ,9 } };
    
  double primam[DIM];

  MPI::Init(argc, argv);
  int mojID       = MPI::COMM_WORLD.Get_rank();
  int brojProcesa = MPI::COMM_WORLD.Get_size();
  
  if (brojProcesa==DIM) {  
    MPI::COMM_WORLD.Scatter(zaSlanje, DIM, MPI::DOUBLE, primam, DIM, MPI::DOUBLE, 0);
  
    cout << "ID=" << mojID << '\t';
    for (unsigned i=0;i<DIM;i++) 
      cout << primam[i] << ' ';
    cout << endl;
  } else {
    cerr << "program je predvidjen da radi samo na " << DIM << " procesa" << endl;
  }
  
  MPI::Finalize();
}
