#include <iostream>
#include <cmath>
#include <mpi.h>

using namespace std;

inline double f( double x ) {
  return 4.0/(1.0+x*x);
}

double integrate(double pocetak, double kraj, unsigned brojKoraka) {
  double sirinaKoraka = (kraj - pocetak) / double(brojKoraka);
  double sum(0.0);
  for (unsigned i=0; i<brojKoraka; i++) {
    double x=(double(i)+0.5)*sirinaKoraka;
    sum+=f(x);
  }
  sum *= sirinaKoraka;
  return sum;
}

int main(int argc, char **argv) {
  double pi=integrate(0,1,1000);
  cout << "PI=" << pi << " greska = " << fabs(M_PIl-pi) << endl;
}
