#include <iostream>
#include <cmath>
#include <mpi.h>

using namespace std;

inline double f( double x ) {
  return 4.0/(1.0+x*x);
}

double integrate(double pocetak, double kraj, unsigned brojKoraka) {
  double sirinaKoraka = (kraj - pocetak) / double(brojKoraka);
  double sum(0.0);
  for (unsigned i=0; i<brojKoraka; i++) {
    double x=pocetak+((double(i)+0.5)*sirinaKoraka);
    sum+=f(x);
  }
  sum *= sirinaKoraka;
  return sum;
}

int main(int argc, char **argv) {
  double suma(0.0); 
  double pocetak(0.0);
  double kraj(1.0);
  unsigned brojKoraka(1000);
  double pi(0.0);

  MPI::Init(argc, argv);
  int mojID       = MPI::COMM_WORLD.Get_rank();
  int brojProcesa = MPI::COMM_WORLD.Get_size();
  
  // mojaSuma predstavlja lokalni deo sume 
  double mojaSuma(0.0);
  
  // ukupan broj koraka deli se na broj procesa (+1) se dodaje 
  // zbog celobrojnog deljenja, sto ne utice preterano na preciznost
  // izracunavanja. Tj samo moze da je poveca!  
  unsigned brojKorakaPoProcesu = ( brojKoraka / brojProcesa )+1;
  
  // racunanje sirine, pocetka i kraja intervala
  double sirinaPoProcesu = (kraj-pocetak) / brojProcesa;  
  double pocetakPoProcesu = pocetak + mojID * sirinaPoProcesu;
  double krajPoProcesu    = pocetakPoProcesu + sirinaPoProcesu;  
  
  // lokalna suma se racuna f-jom integrate
  mojaSuma = integrate(pocetakPoProcesu, krajPoProcesu, brojKorakaPoProcesu);

  // Reduce ce sada dodati izracunatu sumu na promenljivu pi 
  MPI::COMM_WORLD.Reduce(&mojaSuma, &pi, 1, MPI_DOUBLE, MPI_SUM, 0);
  
  if (mojID==0) {
    cout << "PI=" << pi << " greska = " << fabs(M_PIl-pi) << endl;
  }
  
  MPI::Finalize(); 
}

