/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
 * dokument: matrica.cc
 * opis    : Deklaracija apstraktne klase matrica
 *           klasa matrica obezbedjuje osnovne metode za pristup elementima 
 *           matrice, metode za manipulaciju redovima i kolonama matrice,
 *           metode za svodjenje na gornju/donju/diagonalnu trougaonu matricu
 *           kao i metode potrebne za resavanje sistema jednacina 
 *           gausovim direktnim i jacobievim iterativnim postupkom
 *
 *           klasa ne obezbedjuje fizicko cuvanje podataka, za to se brinu
 *           klase koje su izvedene iz klase matrica
**/

#if !defined matrica_hh
#define matrica_hh

#include <iostream>
#include <vector>

#include "defs.h"
#include "common.h"

using namespace std;

namespace jwork {

class matrica {
  private:
    unsigned _sirina;          // Sirina matrice
    unsigned _visina;          // Visina matrice
  protected:
    // promena promenljivih sirina/visina
    void promeni_dimenzije(unsigned sirina, unsigned visina);
  public:

    #if defined BROJANJE

    // staticke promenljive (zajednicke za sve instance klase matrice )
    // koje se koriste za vremensku analizu algoritma
    static unsigned long broj_get_operacija;
    static unsigned long broj_set_operacija;
    static unsigned long broj_sabiranja;
    static unsigned long broj_mnozenja;

    #endif

    // podrazumevani konstruktor
    matrica(unsigned _sirina, unsigned _visina);
    
    // apstraktne metode koje nece biti implementirane u ovoj klasi moraju
    // biti navedene u svakoj podklasi, makar nista ne radile. da bi klasa 
    // mogla biti instancirana kao objekat

    // get/set - uzimanje/postavljanje broja na koordinate x,y
    virtual T get(unsigned x, unsigned y) const = 0;
    virtual void set(unsigned x, unsigned y, T broj) = 0;

    // size vraca realno zauzece memorije koju dati objekat koristi
    virtual unsigned size() const = 0;

    // postavlja sve elemente na nulu
    // ovaj metod moze raditi i apstraktna klasa ali ovim se obezbedjuje
    // najbrzi moguci nacin
    virtual void nule() = 0;

    // redimenzionise matricu (promena dimenzije, i alociranje novog sadrzaja)
    virtual void postaviNovuMatricu(unsigned sirina, unsigned visina) = 0;

    // vraca dimenzije matrice
    inline unsigned sirina() const { return _sirina; }
    inline unsigned visina() const { return _visina; }

    // ispuna matrice slucajnim brojevima iz opsega [-max;max]
    // gde ce se svi brojevi iz opsega [-min;min] racunati kao 0
    // metod se koristi za testiranje velikih sistema
    void randomN(T max=10, T min=0);

    // pravi jedinicnu matricu
    void napraviJedinicnu();

    // osnovne manipulacije sa redovima i kolonama matrice
    void zameniKolone(unsigned k1, unsigned k2);
    void zameniRedove(unsigned r1, unsigned r2);
    void pomnoziIDodajKolonu(unsigned k1, T faktor, unsigned k2);
    void pomnoziKolonu(unsigned k, T faktor);
    void pomnoziIDodajRed(unsigned r1, T faktor, unsigned r2);
    void pomnoziRed(unsigned r, T faktor);

    // metode potrebne za kramerovo pravilo
    void izvadiKolonu(unsigned k, matrica & b) const;
    void zameniKolonu(unsigned k, const matrica & b);

    // racunanje norme matrice
    T absSumaReda(unsigned r);
    T absSumaKolone(unsigned k);
    T normaRedova();
    T normaKolona();

    bool normaRedovaZaJacobi( T & norma );
    bool normaKolonaZaJacobi( T & norma );

    // vraca true ukoliko je matrica kvadratna
    bool kvadratna() const;

    // familija funkcija za gausovu metodu eliminacija
    bool gaussDoleNule(matrica * M=0);
    bool gaussGoreNule(matrica * M=0);
    bool gaussDoleNulePivot(matrica * M=0, short * sgn=0);
    bool gaussGoreNulePivot(matrica * M=0);
    bool gaussDiag(matrica * M=0);
    bool gaussInverzna(matrica & A1);               // A^-1
    bool gaussResiSistem(matrica * b,matrica * x);  // resava sistem
    T gaussDeterminanta();                          // racuna determinantu

    // funkcije za jacobi-evu metodu iteracija
    void pripremiZaJacobi(matrica &b);
    void jacobiIteracija(matrica &b, matrica &x, vector<T> & maxRazlike, bool gausSaidel=false) const;


    ostream & ispisi(ostream & ostr, matrica * b=0) const ;
    ostream & ispisi1(ostream & ostr) const ;
   
    friend ostream & operator << ( ostream & ostr , const matrica & M );
};

// funkcije vezane za brojanje operacija, kratke inkrement funkcije su inline
// i pri prevodjenju bez makroa #BROJANJE one se nece ni kompajlirati jer su
// tada prazne funkcije !!! tako da se na efektivnosti ne gubi

void resetujBrojace();
void ispisiStanjeBrojaca(ostream & ostr);

inline void broji_get() {
#if defined BROJANJE
  matrica::broj_get_operacija++;  
#endif
}
inline void broji_set() {
#if defined BROJANJE
  matrica::broj_set_operacija++;  
#endif
}
inline void broji_add(unsigned a=1) {
#if defined BROJANJE
  matrica::broj_sabiranja+=a;  
#endif
}
inline void broji_mul(unsigned a=1) {
#if defined BROJANJE
  matrica::broj_mnozenja+=a;  
#endif
}

} // namespace

#endif
