/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#include <iostream>
#include <vector>

#include "common.h"
#include "matrica.hh"
#include "gustaMatrica.hh"
#include "gustaKvadratnaMatrica.hh"
#include "gustaSimetricnaMatrica.hh"
#include "retkaMatrica.hh"

#include "matmulPthreads.hh"
 
using namespace std;

namespace jwork {


pthread_mutex_t mutex;

const gustaMatrica *pA,*pB;
gustaMatrica *pC;

unsigned elementMatriceC;
unsigned brojElemenataMatriceC;

struct args_t {
  int nitID;
};


void * thrMatMul (void *voidargs)
{
  struct args_t *args = (struct args_t *) voidargs;  // Ocitavanje argumenata

//  cout << "kreiram nit " << args->nitID << endl;

  unsigned t;
  while ( true ) {
    pthread_mutex_lock(&mutex);
      t=elementMatriceC;
      elementMatriceC++;
    pthread_mutex_unlock(&mutex);
    if (t>=brojElemenataMatriceC)
      break;

    unsigned x,y;
    y=t / pC->sirina();
    x=t % pC->sirina();

    T sum(0.0);

    for (unsigned k=0;k<pA->sirina();k++)
      sum+=pA->get(k,y)*pB->get(x,k);

    pC->set(x,y,sum);  
  }  

//  cout << "zavrsavam nit " << args->nitID << endl;

  pthread_exit (NULL);                // kraj niti!
}

unsigned matmulPthreads(const gustaMatrica & _A, const gustaMatrica & _B, gustaMatrica & _C, unsigned num_of_threads) {

  pthread_t *niti;
  pthread_attr_t attr;
  struct args_t *args;
  int rc, t, status; 

  if (_A.sirina()!=_B.visina())
    throw DIMENZIJE_NISU_SAGLASNE;
  
  _C.postaviNovuMatricu(_B.sirina(),_A.visina());


  pA=&_A;
  pB=&_B;
  pC=&_C;

  pthread_attr_init (&attr);

  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_JOINABLE);

  pthread_mutex_init (&mutex, NULL);
  
  niti = (pthread_t *) malloc (num_of_threads * sizeof (pthread_t));

  args =(struct args_t *) malloc (num_of_threads * sizeof (struct args_t));

  elementMatriceC = 0;
  brojElemenataMatriceC = _C.sirina()*_C.visina();

  for (t = 0; t < num_of_threads; t++) {
    args[t].nitID = t;
    if ((rc = pthread_create (&niti[t], &attr, thrMatMul, (void *) &args[t]))) {
      cerr << "pthread_create() greska broj: " <<  rc << endl;
      throw PTHREAD_GRESKA;
    }
  }

  pthread_attr_destroy (&attr);

  for (t = 0; t < num_of_threads; t++) {
    if ((rc = pthread_join (niti[t], (void **) &status))) {
      cerr << "pthread_join() greska broj: " <<  rc << endl;
      throw PTHREAD_GRESKA;
    }
  }

}

} // namespace

