#include "matrice.h"
#include "mpi.h"

using namespace std;
using namespace jwork;

typedef gustaMatrica MTX;

#include "distrGustaMatrica.hh"

distrGustaMatrica A;
distrGustaMatrica b;

bool master(unsigned np,unsigned n) {

  if (np<2) {
    cerr << "Program je predvidjen da radi na bar 2 procesora" << endl;
    return false;
  }

  
  A.postaviNovuMatricu(n,n);
  b.postaviNovuMatricu(1,n);
  A.randomN(3);
  b.randomN(4);
  
resetujBrojace();

  A.MPI_Bcast(0);
  b.MPI_Bcast(0);

  MTX tmp(1,A.visina());

//  MTX Q(A),W(b),X(b);
//  SLJ_Gauss(Q,W,X);
   
  T determinante[A.visina()+1];
  int jednacine[A.visina()+1];
  unsigned iter(0);
  
  unsigned processor(1);

resetujBrojace();
  for (int i=-1;i<int(n);i++) {
    MPI::COMM_WORLD.Send( &i, 1, MPI::INT, processor, 0);
    
    processor++;
    
    if (processor==np) {
      i++;
      
      if (i==n)
        break;
      
      A.izvadiKolonu(i,tmp);
      A.zameniKolonu(i,b);     
        determinante[iter]=determinanta(A);
        jednacine[iter]=i;
        iter++;
      A.zameniKolonu(i,tmp);

      processor=1;
    }
    
  }

  int terminator(TERMINATE);

  for (unsigned k=1;k<np;k++) 
    MPI::COMM_WORLD.Send( &terminator, 1, MPI::INT, k, 0);
  
  T detSistema(0.0);
  T detS[A.visina()];
  for (unsigned i=0;i<A.visina();i++)
    detS[i]=0;
  
  for (unsigned i=0;i<iter;i++)
    detS[ jednacine[i] ] = determinante[i];

  for (unsigned k=1;k<np;k++) {
    unsigned ukupnoIzracunato;    
    MPI::COMM_WORLD.Recv( &ukupnoIzracunato, 1, MPI::UNSIGNED, k, 0);
    MPI::COMM_WORLD.Recv( determinante, ukupnoIzracunato, MPI_T, k, 0);
    MPI::COMM_WORLD.Recv( jednacine, ukupnoIzracunato, MPI::UNSIGNED, k, 0);
    
    for (unsigned i=0;i<ukupnoIzracunato;i++) {
      if (jednacine[i]==-1)
        detSistema=determinante[i];
      else
        detS[ jednacine[i] ] = determinante[i];
    }
  }

cout << "n=" << n << '\t' << "sysDET = " << detSistema << "\t np=" << np << "\t";
ispisiStanjeBrojaca(cout);  

//  double norm=0;
//  for (unsigned i=0;i<A.visina();i++) {
//    norm+=fabs(fabs(detS[i]/detSistema)-fabs(X.get(0,i)));
//    cout << redukuj_sirinu(detS[i]/detSistema,10) << "  " << redukuj_sirinu(X.get(0,i),10) << endl;
//    cout << redukuj_sirinu(detS[i]/detSistema,10) << endl;
//  }
//  cout << norm << endl;


  return true;

} // master

void slave(unsigned rank) {
  
  A.MPI_Bcast(rank);
  b.MPI_Bcast(rank);

  MTX tmp(1,A.visina());  
  
  T determinante[A.visina()+1];
  int jednacine[A.visina()+1];
  unsigned iter(0);
  
  while ( true ) {
    int jednacina;
    MPI::COMM_WORLD.Recv(&jednacina, 1, MPI::INT, 0, 0);
//    cout << "RANK(" << rank << ") jednacina=" << jednacina << endl;
    if (jednacina==TERMINATE)
      break;
    if (jednacina==-1) {
      determinante[iter]=determinanta(A);
      jednacine[iter]=-1;
      iter++;
    } else {
      A.izvadiKolonu(jednacina,tmp);
      A.zameniKolonu(jednacina,b);     
        determinante[iter]=determinanta(A);
        jednacine[iter]=jednacina;
        iter++;
      A.zameniKolonu(jednacina,tmp);
    }
  }

//  cout << "RANK(" << rank << ") je izracunao " << iter << " determinanti :";
//  for (unsigned i=0;i<iter;i++)
//    cout << 'd' << jednacine[i] << '=' << determinante[i] << "; ";
//  cout << endl;

  MPI::COMM_WORLD.Send( &iter, 1, MPI::UNSIGNED, 0, 0);
  MPI::COMM_WORLD.Send( determinante, iter, MPI_T, 0, 0);
  MPI::COMM_WORLD.Send( jednacine, iter, MPI::UNSIGNED, 0, 0);
  
}

int main(int argc, char **argv) {
  try {

    unsigned size_n=10;
    if (argc>1)
      size_n=atoi(argv[1]);
      
    if (size_n<=0)
      size_n=10;

    MPI::Init(argc,argv);
    int rank,size;

    rank=MPI::COMM_WORLD.Get_rank();
    size=MPI::COMM_WORLD.Get_size();  
    if (rank==0) master(size,size_n); else slave(rank); 
    MPI::Finalize();
    
  } catch( int err ) {
    cerr << "ERROR!! " << err << endl;
  }
}
