

// skini argumente prenosene nitima, nisu ti uopste potrebni


/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
 * dokument: jacobiPthreads.cc
 * opis    : Jacobi-jeva metoda za resavanje dijagonalno dominantne matrice
 *           se paralelizuje na cvrsto povezanim viseprocesorskim sistemima
 *           koriscenjem tzv. Niti (odnosno procesa koji rade paralelno)
 *           Niti su procesi koji mogu biti instancirani i na sistemu sa 
 *           jednim procesom, ali tada su rezultati u najvecem broju slucajeva
 *           losiji od sekvencijalnog algoritma jer se gubi vreme na 
 *           pseudo paralelizmu.
**/
 
#include <iostream>
#include <vector>

#include "common.h"
#include "matrica.hh"
#include "gustaMatrica.hh"
#include "gustaKvadratnaMatrica.hh"
#include "gustaSimetricnaMatrica.hh"
#include "retkaMatrica.hh"
#include "jacobiPthreads.hh"

using namespace std;

namespace jwork {

/*
 * Mutex (Mutual Exclusion) promenljiva se koristi kako bi bilo spreceno
 * da se nekoj promenljivoj pristupi u istom trenutku kada ona moze biti 
 * menjana od neke druge niti!..
 * pre ulaska u kriticnu zonu mutex-om se zakljucava ista, taj proces nece
 * proci ukoliko je mutexom vec zakljucana kriticna zona tako da ce proces(i)
 * cekati dok neki od njih koji drzi kriticnu sekciju ne otkljuca mutex.
 * zatim ce po nekom od algoritama (najcesce slucajnom) uci neki od procesa
 * koji ceka!
 */

pthread_mutex_t mutex_red,mutex_max;

/*
 * Paralelizacija se moze sprovesti na vise nacina:
 *  - jedan od njih je da svaki proces(or) obradjuje po jednu jednacinu
 *    idealno ali najcesce je broj procesora ogranicen, i mnogo manji od
 *    broja jednacina koje treba resiti. Instanciranje vise procesa nego
 *    sto posedujemo procesora u ovoj numerickoj metodi ne bi imalo smisla
 *  - sledeca prirodna ideja je da se broj jednacina podeli na broj 
 *    postojecih procesora. Ali tada bi broj jednacina morao biti deljiv
 *    sa brojem procesora, a ni tim se ne bi napravila prava ravnoteza jer
 *    se neke jednacine resavaju brze od drugih pa iskoriscenost svih 
 *    procesora ne bi bila ista (u sve ovo se uopste ne uzima mogucnost
 *    da operativni sistem forsira neke druge procese na koje procesi
 *    kreirani u ovom programu ne mogu da uticu.
 *  - metoda koja je primenjena u ovom algoritmu maksimalno koristi asinhronost
 *    procesa. Na pocetku program instancira potreban broj niti (npr koji
 *    odgovara broju procesora na sistemu). Sve niti uzimaju poslove iz
 *    reda poslova, ustvari ideja je da nit treba da obradi jednu jednacinu
 *    iz sistema jednacina i zatim uzme prvu sledecu koja je neobradjena
 *    time se izbegava nepotrebno deljenje odredjenih jednacina odredjenim
 *    nitima i kontrola samih niti vec se poslovi i odluke o tome sta ce ko 
 *    da radi prepustaju nitima. pristup promenljivoj redZaObradu se obezbedjuje
 *    mutexom kako ne bi u isto vreme dve niti inkremetirale promenljivu
 *    i samim tim preskocile neki red
 */
 
unsigned redZaObradu,brojRedova;

struct args_t {      // struktura args_t se koristi za prenos argumenta niti.
  int nitID;         // u ovom slucaju radi se samo o rednom broju niti, tako da
};                   // je moguce koristiti i sam int (jer je int isto sto i 
                     // pokazivac) ali ovako je pravilnije

/*
 * Matrice u koje se kopira problem koji se resava, na pocetku su 
 * inicijalizovane na najmanju mogucu vrednost kako ne bi zauzimale
 * memoriju. Po startu glavne niti one se realociraju i primaju parametre
 * koji su im poslati preko reference. Na kraju matrice se ponovo 
 * redimenzionisu na minimum
 */

gustaMatrica A(1,1),b(1,1);
gustaMatrica *x;

T *y;                               // privremena matrica za x
T norma;                            // norma
T *maxRazlika;                      // niz Maksimalnih razlika - koristi se 
                                    // za kriterijum za zaustavljanje

/*
 * funkcija thrPripremiZaJacobi predstavlja nit koja se koristi u pripremi
 * u pripremi matrica A za metodu iteracija tako sto deli sve elemente 
 * sa -1/a_ii (dijagonalno dominantnim elementom). 
 */

void * thrPripremiZaJacobi (void *voidargs)
{
  struct args_t *args = (struct args_t *) voidargs;  // Ocitavanje argumenata
  int t;
  while( true ) {                                    // beskonacna petlja
    pthread_mutex_lock(&mutex_red);                  // udji i zakljucaj vrata
    t=redZaObradu;                                   // t preuzima redni broj reda
    redZaObradu++;                                   // inkrementacija reda
    pthread_mutex_unlock(&mutex_red);                // izlaz iz kriticne sekcije

    if (t>=brojRedova)           // Ukoliko je tekuci red prevazisao ukupan broj
      break;                     // redova proces se prekida

    T a(A.get(t,t));             // ocitavanje dijagonalno dominantnog elementa
    A.set(t,t,0);                // na njegovo mesto se postavlja 0
    A.pomnoziRed(t,-1/a);        // mnozi ceo red matrice A
    b.pomnoziRed(t,1/a);         // mnozi se red matrice b

    T sum(A.absSumaReda(t));     // racuna se suma reda za racunanje norme

    pthread_mutex_lock(&mutex_max);   // norma se mora uporediti sa ostalim
    if (norma<sum)                    // kolonama, medjutim promenljiva norma
      norma=sum;                      // je globalna i u istom trenutku joj 
    pthread_mutex_unlock(&mutex_max); // mogu prici vise niti zato se ona
  }                                   // ogradjuje mutexom

  pthread_exit (NULL);                // kraj niti!
}

/*
 * funkcija koja instancira niti za pripremu matrice
 */

void pripremiZaJacobiPthreads(unsigned num_of_threads) {

  pthread_t *niti;     // niz pokazivaca na kreirane niti
  pthread_attr_t attr; // atributi niti
  struct args_t *args; // argumenti koji se prenose nitima
  int rc, t, status; 

  // inicijalizovanje atributa niti
  pthread_attr_init (&attr);

  // status niti je JOINABLE tj po instanciranju svih niti bice
  // moguce sakupljanje istih, kako se glavna nit tj ova f-ja
  // ne bi zavrsila pre svojih sinova (niti).. druga mogucnost
  // je DETACHABLE ali ona nije korisna u ovoj primeni

  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_JOINABLE);

  // inicijalizacija mutex promenljivih
  pthread_mutex_init (&mutex_red, NULL);
  pthread_mutex_init (&mutex_max, NULL);
  
  // alociranje niza pokazivaca na niti
  niti = (pthread_t *) malloc (num_of_threads * sizeof (pthread_t));

  // alociranje pokazivaca na strukturu za prenos argumenata
  args =(struct args_t *) malloc (num_of_threads * sizeof (struct args_t));

  // prvi red za obradu je nulti
  redZaObradu = 0;

  // ukupan broj redova je jednak visini matrice
  brojRedova = A.visina();

  // iteracijom po broju niti instancira se potreban broj niti.
  for (t = 0; t < num_of_threads; t++) {
    args[t].nitID = t;
    if ((rc = pthread_create (&niti[t], &attr, thrPripremiZaJacobi, (void *) &args[t]))) {
      cerr << "pthread_create() greska broj: " <<  rc << endl;
      throw PTHREAD_GRESKA;
    }
  }

  // unistava se attr
  pthread_attr_destroy (&attr);

  // skupljaju se niti koje su zavrsile posao
  for (t = 0; t < num_of_threads; t++) {
    if ((rc = pthread_join (niti[t], (void **) &status))) {
      cerr << "pthread_join() greska broj: " <<  rc << endl;
      throw PTHREAD_GRESKA;
    }
  }
  // kada su sve niti skupljenje, otac (ova funkcija) moze zavrsiti
  // posao! 
}

/*
 * funkcija thrJacobiObradi predstavlja nit koja obradjuje jednu po jednu
 * jednacinu, tj jednacinu koja je sledeca na redu, slicno kao i prethodna
 * nit za pripremu
 */

void * thrJacobiObradi(void *voidargs)
{
  struct args_t *args = (struct args_t *) voidargs;
  int t;
  while( true ) {
    pthread_mutex_lock(&mutex_red);
    t=redZaObradu;
    redZaObradu++;
    pthread_mutex_unlock(&mutex_red);

    if (t>=brojRedova)
      break;

    unsigned n(x->visina()),m(x->sirina());

  // iteracija po broju sistema jednacina (po sirini matrice b)
  for (unsigned k=0;k<m;k++) {
    unsigned offset=n*k;       // ofset je start niza y[] koji sadrzi matricu x
                               // ustvari niz y je dinamicki alocirana matrica
    T sum(0.0);                // sum=0. je resenje jedne iteracije tekuce jednacine

    for (unsigned i=0;i<n;i++) {    // iteracija po sirini matrice A
      sum+=y[offset+i]*A.get(i,t);  // na sumu se dodaje stara vrednost za x 
    }
    sum+=b.get(k,t);                // na kraju se na sumu dodaje vrednost iz b
    x->set(k,t,sum);                 // na x se postavlja novoizracunata vrednost

    // razlika predstavlja razliku nove i stare vrednosti!
    T razlika=fabs(fabs(sum)-fabs(y[offset+t]));

    // ukoliko je veca od prethodne izracunate za taj sistem tada se ona pamti
    if (razlika>maxRazlika[k])      // u maxRazlika[k]
      maxRazlika[k]=razlika;
  }

  } // while

  pthread_exit (NULL);
}

/*
 * jedna iteracija, je otac funkcija koja za jednu iteraciju sistema
 * instancira potreban broj niti koje racunaju iteraciju odvojeno po
 * jednacinama
 */

void iteracija(unsigned num_of_threads) {

  pthread_t *niti;
  pthread_attr_t attr;
  struct args_t *args;
  int rc, t, status;

  pthread_attr_init (&attr);
  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_JOINABLE);
  pthread_mutex_init (&mutex_red, NULL);
  niti = (pthread_t *) malloc (num_of_threads * sizeof (pthread_t));
  args =(struct args_t *) malloc (num_of_threads * sizeof (struct args_t));

  // niz y dobija vrednost starog x-a 
  unsigned e(0);
  for (unsigned w=0;w<b.sirina();w++)
    for (unsigned q=0;q<b.visina();q++)
    y[e++]=x->get(w,q);


  redZaObradu = 0;            // pocinje se od 0-tog reda
  brojRedova = A.visina();    // za ukupno A.visina() reda

  // instancira se potrebeban broj niti
  for (t = 0; t < num_of_threads; t++) {
    args[t].nitID = t;
    if ((rc = pthread_create (&niti[t], &attr, thrJacobiObradi, (void *) &args[t]))) {
      cerr << "pthread_create() greska broj: " <<  rc << endl;
      throw PTHREAD_GRESKA;
    }
  }
  pthread_attr_destroy (&attr);

  // skupljaju se niti koje su zavrsile posao
  for (t = 0; t < num_of_threads; t++) {
    if ((rc = pthread_join (niti[t], (void **) &status))) {
      cerr << "pthread_join() greska broj: " <<  rc << endl;
      throw PTHREAD_GRESKA;
    }
  }
}

/*
 * glavna funkcija koju poziva korisnik programa
 * jacobiPthreads - kopira sadrzaje matrica koje su mu 
 * prenete po referenci u globalne promenljive koje se zatim
 * koriste za resavanje sistema
 */

unsigned jacobiPthreads(const gustaMatrica & _A, const gustaMatrica & _b, gustaMatrica & _x, unsigned num_of_threads) {

  A=_A;    // pomocu operatora dodele vrednosti podaci se prenose na 
  b=_b;    // globalne matrice, resenje x ce biti dimenzije

// zameni ovo sa _x.postaviNovuMatricu
// **********************************************


  _x=_b;   // kao matrica _b, pa se njome i instancira

  x=&_x;

  norma=0; // norma se postavlja na minimalnu vrednost

  // priprema za jakobijev postupak prevodi 
  // sistem Ax=b u sistem x=Bx+c
  // i ujedno racuna normu matrice B

  pripremiZaJacobiPthreads(num_of_threads);

  unsigned n(b.visina()),m(b.sirina());
  maxRazlika=new T[m];  // koristi se za zaustavljanje
  y=new T[n*m];         // cuva stare vrednosti x-a

  T q=norma;            // koeficijent kontrakcije
  if (q>=1)
    throw NORMA_NEODGOVARA;
  
  T qq=q/(1-q);
  
  // iteracija pocinje od nule
  x->nule();

  unsigned i;
  // iteracija do maksimalnog broja koraka
  // for petlja ce biti prekinuta kada se bude
  // postigla zeljena tacnost

  for (i=0;i<MAXITER;i++) {

    // razlika se postavlja na 0
    for (unsigned k=0;k<x->sirina();k++)
      maxRazlika[k]=0;

    // pozivanje iteracije za zadat broj niti
    iteracija(num_of_threads);
    
    // racunanje maksimalne razlike
    T max(0.0);
    for (unsigned k=0;k<x->sirina();k++) {
      if (max<maxRazlika[k])
        max=maxRazlika[k];
    }

    // kriterijum zaustavljanja
    if (qq*max < EPSILON)
      break;
  }

  // resetovanje globalnih promenljivih!
  delete [] y;
  delete [] maxRazlika;
  A=gustaMatrica(1,1);  b=gustaMatrica(1,1);  

  return i;
}

} // namespace

