/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
 * dokument: gustaMatrica.cc
 * opis    : Definicija klase gustaSimetricnaMatrica
 *           sa matematicke strane simetricna matrica bi trebalo da bude 
 *           specijalizacija kvadratne, ali time ne bi bio postignut efekat
 *           ustede memorije jer je kvadratna matrica kontejner, tako da 
 *           simetricna matrica predstavlja samo simetrican kontejner
 *           koji je naravno kvadratna matrica. U ovoj klasi je glavni
 *           zadatak pristupu elemtima, sve ostalo je implementirano slicno
 *           kao u klasi kvadratnaMatrica
 *
 * napomena: ako se nad ovom matricom rade manipulacije nad redovima i kolonam
 *           nece se postici ocekivan efekat jer matrica uvek zadrzava svoju
 *           simetricnost, tako da se ova matrica koristi za cuvanje 
 *           simetricnih matrica i konstantne operacije nad njima kao i za
 *           operacije koje nece kvariti njenu simetricnost
 *           racunanje determinante ili inverzne matrice gausovim postupkom
 *           kod ovog kontejnera nece dati ispravan rezultat
**/

#if !defined gustaSimetricnaMatrica_hh
#define gustaSimetricnaMatrica_hh

#include <iostream>
#include "matrica.hh"

using namespace std;

namespace jwork {

class gustaSimetricnaMatrica : public matrica {
  private:
    T *data;
    unsigned sz;

  public:
    gustaSimetricnaMatrica(unsigned dim);
    gustaSimetricnaMatrica(const gustaSimetricnaMatrica &A);
    gustaSimetricnaMatrica & operator=(const gustaSimetricnaMatrica &A);
    ~gustaSimetricnaMatrica();

    // konkretizacija virtualnih metoda iz apstraktne klase matrica
    T get(unsigned x, unsigned y) const;
    void set(unsigned x, unsigned y, T broj);
    unsigned size() const;
    void nule();

    // preopterecenje metode randomN
    void randomN(T max=10, T min=0);

    // neki aritmeticki i poredbeni operatori
    gustaSimetricnaMatrica & operator += ( const gustaSimetricnaMatrica & B );
    gustaSimetricnaMatrica & operator -= ( const gustaSimetricnaMatrica & B );
    gustaSimetricnaMatrica & operator *= ( T faktor );
    gustaSimetricnaMatrica & operator /= ( T faktor );
    bool operator == ( const gustaSimetricnaMatrica & B ) const ;
    bool operator != ( const gustaSimetricnaMatrica & B ) const ;

};

} // namespace

#endif
